/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.connect;

import com.google.common.base.Strings;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.connect.ConnectionSettings;
import com.mx.path.core.common.connect.RequestFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class AccessorConnectionSettings
implements ConnectionSettings {
    private String baseUrl;
    private String certificateAlias;
    private ObjectMap configurations;
    private char[] keystorePassword;
    private String keystorePath;
    private List<RequestFilter> baseRequestFilters;
    private boolean skipHostNameVerify;

    @Override
    public final boolean getSkipHostNameVerify() {
        return this.skipHostNameVerify;
    }

    @Override
    public final void describe(ObjectMap description) {
        if (com.mx.path.core.common.lang.Strings.isNotBlank(this.baseUrl)) {
            description.put("baseUrl", this.baseUrl);
        }
        if (com.mx.path.core.common.lang.Strings.isNotBlank(this.certificateAlias)) {
            description.put("certificateAlias", this.certificateAlias);
        }
        if (this.keystorePassword != null) {
            description.put("keystorePassword", Strings.repeat((String)"*", (int)this.keystorePassword.length));
        }
        if (com.mx.path.core.common.lang.Strings.isNotBlank(this.keystorePath)) {
            description.put("keystorePath", this.keystorePath);
        }
        if (this.skipHostNameVerify) {
            description.put("skipHostNameVerify", true);
        }
        if (!this.configurations.isEmpty()) {
            ObjectMap configs = description.createMap("configurations");
            this.configurations.forEach(configs::put);
        }
    }

    @Generated
    public static AccessorConnectionSettingsBuilder builder() {
        return new AccessorConnectionSettingsBuilder();
    }

    @Override
    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Generated
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Generated
    public ObjectMap getConfigurations() {
        return this.configurations;
    }

    @Override
    @Generated
    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    @Generated
    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Override
    @Generated
    public List<RequestFilter> getBaseRequestFilters() {
        return this.baseRequestFilters;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    @Generated
    public void setConfigurations(ObjectMap configurations) {
        this.configurations = configurations;
    }

    @Generated
    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    @Generated
    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    @Generated
    public void setBaseRequestFilters(List<RequestFilter> baseRequestFilters) {
        this.baseRequestFilters = baseRequestFilters;
    }

    @Generated
    public void setSkipHostNameVerify(boolean skipHostNameVerify) {
        this.skipHostNameVerify = skipHostNameVerify;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessorConnectionSettings)) {
            return false;
        }
        AccessorConnectionSettings other = (AccessorConnectionSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSkipHostNameVerify() != other.getSkipHostNameVerify()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$certificateAlias = this.getCertificateAlias();
        String other$certificateAlias = other.getCertificateAlias();
        if (this$certificateAlias == null ? other$certificateAlias != null : !this$certificateAlias.equals(other$certificateAlias)) {
            return false;
        }
        ObjectMap this$configurations = this.getConfigurations();
        ObjectMap other$configurations = other.getConfigurations();
        if (this$configurations == null ? other$configurations != null : !((Object)this$configurations).equals(other$configurations)) {
            return false;
        }
        if (!Arrays.equals(this.getKeystorePassword(), other.getKeystorePassword())) {
            return false;
        }
        String this$keystorePath = this.getKeystorePath();
        String other$keystorePath = other.getKeystorePath();
        if (this$keystorePath == null ? other$keystorePath != null : !this$keystorePath.equals(other$keystorePath)) {
            return false;
        }
        List<RequestFilter> this$baseRequestFilters = this.getBaseRequestFilters();
        List<RequestFilter> other$baseRequestFilters = other.getBaseRequestFilters();
        return !(this$baseRequestFilters == null ? other$baseRequestFilters != null : !((Object)this$baseRequestFilters).equals(other$baseRequestFilters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccessorConnectionSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getSkipHostNameVerify() ? 79 : 97);
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $certificateAlias = this.getCertificateAlias();
        result = result * 59 + ($certificateAlias == null ? 43 : $certificateAlias.hashCode());
        ObjectMap $configurations = this.getConfigurations();
        result = result * 59 + ($configurations == null ? 43 : ((Object)$configurations).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeystorePassword());
        String $keystorePath = this.getKeystorePath();
        result = result * 59 + ($keystorePath == null ? 43 : $keystorePath.hashCode());
        List<RequestFilter> $baseRequestFilters = this.getBaseRequestFilters();
        result = result * 59 + ($baseRequestFilters == null ? 43 : ((Object)$baseRequestFilters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AccessorConnectionSettings(baseUrl=" + this.getBaseUrl() + ", certificateAlias=" + this.getCertificateAlias() + ", configurations=" + this.getConfigurations() + ", keystorePassword=" + Arrays.toString(this.getKeystorePassword()) + ", keystorePath=" + this.getKeystorePath() + ", baseRequestFilters=" + this.getBaseRequestFilters() + ", skipHostNameVerify=" + this.getSkipHostNameVerify() + ")";
    }

    @Generated
    public AccessorConnectionSettings() {
    }

    @Generated
    public AccessorConnectionSettings(String baseUrl, String certificateAlias, ObjectMap configurations, char[] keystorePassword, String keystorePath, List<RequestFilter> baseRequestFilters, boolean skipHostNameVerify) {
        this.baseUrl = baseUrl;
        this.certificateAlias = certificateAlias;
        this.configurations = configurations;
        this.keystorePassword = keystorePassword;
        this.keystorePath = keystorePath;
        this.baseRequestFilters = baseRequestFilters;
        this.skipHostNameVerify = skipHostNameVerify;
    }

    public static class AccessorConnectionSettingsBuilder {
        @Generated
        private String baseUrl;
        @Generated
        private String certificateAlias;
        @Generated
        private char[] keystorePassword;
        @Generated
        private String keystorePath;
        @Generated
        private boolean skipHostNameVerify;
        private ObjectMap configurations = new ObjectMap();
        private List<RequestFilter> baseRequestFilters = new LinkedList<RequestFilter>();

        public final AccessorConnectionSettingsBuilder configuration(String key, Object value) {
            this.configurations.put(key, value);
            return this;
        }

        public final AccessorConnectionSettingsBuilder baseRequestFilter(RequestFilter requestFilter) {
            this.baseRequestFilters.add(requestFilter);
            return this;
        }

        @Generated
        AccessorConnectionSettingsBuilder() {
        }

        @Generated
        public AccessorConnectionSettingsBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public AccessorConnectionSettingsBuilder certificateAlias(String certificateAlias) {
            this.certificateAlias = certificateAlias;
            return this;
        }

        @Generated
        public AccessorConnectionSettingsBuilder configurations(ObjectMap configurations) {
            this.configurations = configurations;
            return this;
        }

        @Generated
        public AccessorConnectionSettingsBuilder keystorePassword(char[] keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        @Generated
        public AccessorConnectionSettingsBuilder keystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        @Generated
        public AccessorConnectionSettingsBuilder baseRequestFilters(List<RequestFilter> baseRequestFilters) {
            this.baseRequestFilters = baseRequestFilters;
            return this;
        }

        @Generated
        public AccessorConnectionSettingsBuilder skipHostNameVerify(boolean skipHostNameVerify) {
            this.skipHostNameVerify = skipHostNameVerify;
            return this;
        }

        @Generated
        public AccessorConnectionSettings build() {
            return new AccessorConnectionSettings(this.baseUrl, this.certificateAlias, this.configurations, this.keystorePassword, this.keystorePath, this.baseRequestFilters, this.skipHostNameVerify);
        }

        @Generated
        public String toString() {
            return "AccessorConnectionSettings.AccessorConnectionSettingsBuilder(baseUrl=" + this.baseUrl + ", certificateAlias=" + this.certificateAlias + ", configurations=" + this.configurations + ", keystorePassword=" + Arrays.toString(this.keystorePassword) + ", keystorePath=" + this.keystorePath + ", baseRequestFilters=" + this.baseRequestFilters + ", skipHostNameVerify=" + this.skipHostNameVerify + ")";
        }
    }
}

