/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.connect;

import com.mx.path.core.common.collection.MultiValueMap;
import com.mx.path.core.common.collection.MultiValueMappable;
import com.mx.path.core.common.collection.SingleValueMap;
import com.mx.path.core.common.connect.ConnectionSettings;
import com.mx.path.core.common.connect.FormBody;
import com.mx.path.core.common.connect.MisConfiguredFilterChainException;
import com.mx.path.core.common.connect.RequestFilter;
import com.mx.path.core.common.connect.Response;
import com.mx.path.core.common.request.Feature;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;

public abstract class Request<REQ extends Request<?, ?>, RESP extends Response<?, ?>> {
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofMillis(30000L);
    private String baseUrl = null;
    private Object body;
    private String bodyJson;
    private ConnectionSettings connectionSettings;
    private String faultTolerantScope;
    private Feature feature;
    private RequestFilter filterChain;
    private FormBody formBody;
    private SingleValueMap<String, String> headers = new SingleValueMap();
    private String method = "GET";
    private Consumer<RESP> onComplete;
    private String path = "";
    private PreferredResponseBodyType preferredResponseBodyType = PreferredResponseBodyType.INFERRED_FROM_CONTENT_TYPE;
    private Function<RESP, Object> processor;
    private SingleValueMap<String, String> queryStringParams = new SingleValueMap();
    private long startNano = 0L;
    private Duration timeOut;
    private String traceId;
    private String traceSpanId;

    public Request(RequestFilter filterChain) {
        this.headers.put("Accept", "application/json");
        this.headers.put("Content-Type", "application/json");
        if (filterChain == null) {
            throw new MisConfiguredFilterChainException();
        }
        this.setFilterChain(filterChain);
    }

    public void completed(RESP currentResponse) throws RuntimeException {
        if (this.getOnComplete() != null) {
            this.getOnComplete().accept(currentResponse);
        }
    }

    public abstract RESP execute();

    public final String getAccept() {
        return this.headers.get("Accept");
    }

    public final String getContentType() {
        return this.headers.get("Content-Type");
    }

    public final MultiValueMap<String, String> getHeadersAsMultiValueMap() {
        return new MultiValueMap<String, String>(this.headers);
    }

    public final SingleValueMap<String, String> getHeadersAsSingleValueMap() {
        return new SingleValueMap<String, String>(this.headers);
    }

    public final Duration getRequestTimeOut() {
        return this.timeOut == null ? DEFAULT_REQUEST_TIMEOUT : this.timeOut;
    }

    public final String getTraceKey() {
        return this.getMethod() + ":" + this.getPath();
    }

    public final String getUri() {
        StringBuilder uri = new StringBuilder(this.baseUrl);
        StringBuilder p = new StringBuilder(this.path);
        while (uri.length() > 1 && uri.charAt(uri.length() - 1) == '/') {
            uri.setLength(uri.length() - 1);
        }
        while (p.length() > 1 && p.charAt(0) == '/') {
            p.deleteCharAt(0);
        }
        if (p.length() > 1) {
            uri.append('/');
            uri.append((CharSequence)p);
        }
        return uri.toString();
    }

    public final boolean hasBody() {
        return this.body != null;
    }

    public final Object process(RESP currentResponse) {
        if (this.processor != null) {
            return this.processor.apply(currentResponse);
        }
        return null;
    }

    public final void setHeader(String key, String value) {
        this.getHeaders().put(key, value);
    }

    public final void setHeaders(MultiValueMappable<String, String> singleValueMap) {
        this.headers = new SingleValueMap<String, String>(singleValueMap);
    }

    public void start() {
        if (this.startNano == 0L) {
            this.startNano = System.nanoTime();
        }
    }

    public final REQ withAccept(String accept) {
        if (accept == null) {
            this.headers.remove("Accept");
        } else {
            this.headers.put("Accept", accept);
        }
        return (REQ)this;
    }

    public final REQ withBaseUrl(String newBaseUrl) {
        this.setBaseUrl(newBaseUrl);
        return (REQ)this;
    }

    public final REQ withBody(Object newBody) {
        this.setBody(newBody);
        return (REQ)this;
    }

    public final REQ withBodyJson(String newBodyJson) {
        this.setBodyJson(newBodyJson);
        return (REQ)this;
    }

    public final REQ withConnectionSettings(ConnectionSettings newConnectionSettings) {
        this.setConnectionSettings(newConnectionSettings);
        return (REQ)this;
    }

    public final REQ withContentType(String contentType) {
        if (contentType == null) {
            this.headers.remove("Content-Type");
        } else {
            this.headers.put("Content-Type", contentType);
        }
        return (REQ)this;
    }

    public final REQ withFaultTolerantScope(String newFaultTolerantScope) {
        this.setFaultTolerantScope(newFaultTolerantScope);
        return (REQ)this;
    }

    public final REQ withFeature(Feature newFeature) {
        this.setFeature(newFeature);
        return (REQ)this;
    }

    public final REQ withFormBody(FormBody newFormBody) {
        this.setFormBody(newFormBody);
        return (REQ)this;
    }

    public final REQ withHeader(String key, String value) {
        this.setHeader(key, value);
        return (REQ)this;
    }

    public final REQ withHeaders(Consumer<Map<String, String>> headerConsumer) {
        headerConsumer.accept(this.headers);
        return (REQ)this;
    }

    public final REQ withMethod(String newMethod) {
        this.setMethod(newMethod);
        return (REQ)this;
    }

    public final REQ withOnComplete(Consumer<RESP> newOnComplete) {
        this.setOnComplete(newOnComplete);
        return (REQ)this;
    }

    public final REQ withPath(String newPath) {
        this.setPath(newPath);
        return (REQ)this;
    }

    public final REQ withPreferredResponseBodyType(PreferredResponseBodyType responseBodyTypePreference) {
        this.setPreferredResponseBodyType(responseBodyTypePreference);
        return (REQ)this;
    }

    public final REQ withProcessor(Function<RESP, Object> newOnProcess) {
        this.setProcessor(newOnProcess);
        return (REQ)this;
    }

    public final REQ withQueryStringParam(String key, String value) {
        this.queryStringParams.put(key, value);
        return (REQ)this;
    }

    public final REQ withQueryStringParams(SingleValueMap<String, String> newQueryStringParams) {
        this.setQueryStringParams(newQueryStringParams);
        return (REQ)this;
    }

    public final REQ withQueryStringParams(Consumer<SingleValueMap<String, String>> newQueryStringParams) {
        newQueryStringParams.accept(this.getQueryStringParams());
        return (REQ)this;
    }

    public final REQ withTimeOut(Duration requestTimeOut) {
        this.setTimeOut(requestTimeOut);
        return (REQ)this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartNano() != other.getStartNano()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$bodyJson = this.getBodyJson();
        String other$bodyJson = other.getBodyJson();
        if (this$bodyJson == null ? other$bodyJson != null : !this$bodyJson.equals(other$bodyJson)) {
            return false;
        }
        ConnectionSettings this$connectionSettings = this.getConnectionSettings();
        ConnectionSettings other$connectionSettings = other.getConnectionSettings();
        if (this$connectionSettings == null ? other$connectionSettings != null : !this$connectionSettings.equals(other$connectionSettings)) {
            return false;
        }
        String this$faultTolerantScope = this.getFaultTolerantScope();
        String other$faultTolerantScope = other.getFaultTolerantScope();
        if (this$faultTolerantScope == null ? other$faultTolerantScope != null : !this$faultTolerantScope.equals(other$faultTolerantScope)) {
            return false;
        }
        Feature this$feature = this.getFeature();
        Feature other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !((Object)((Object)this$feature)).equals((Object)other$feature)) {
            return false;
        }
        RequestFilter this$filterChain = this.getFilterChain();
        RequestFilter other$filterChain = other.getFilterChain();
        if (this$filterChain == null ? other$filterChain != null : !this$filterChain.equals(other$filterChain)) {
            return false;
        }
        FormBody this$formBody = this.getFormBody();
        FormBody other$formBody = other.getFormBody();
        if (this$formBody == null ? other$formBody != null : !this$formBody.equals(other$formBody)) {
            return false;
        }
        SingleValueMap<String, String> this$headers = this.getHeaders();
        SingleValueMap<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Consumer<RESP> this$onComplete = this.getOnComplete();
        Consumer<RESP> other$onComplete = other.getOnComplete();
        if (this$onComplete == null ? other$onComplete != null : !this$onComplete.equals(other$onComplete)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        PreferredResponseBodyType this$preferredResponseBodyType = this.getPreferredResponseBodyType();
        PreferredResponseBodyType other$preferredResponseBodyType = other.getPreferredResponseBodyType();
        if (this$preferredResponseBodyType == null ? other$preferredResponseBodyType != null : !((Object)((Object)this$preferredResponseBodyType)).equals((Object)other$preferredResponseBodyType)) {
            return false;
        }
        Function<RESP, Object> this$processor = this.getProcessor();
        Function<RESP, Object> other$processor = other.getProcessor();
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        SingleValueMap<String, String> this$queryStringParams = this.getQueryStringParams();
        SingleValueMap<String, String> other$queryStringParams = other.getQueryStringParams();
        if (this$queryStringParams == null ? other$queryStringParams != null : !((Object)this$queryStringParams).equals(other$queryStringParams)) {
            return false;
        }
        Duration this$timeOut = this.timeOut;
        Duration other$timeOut = other.timeOut;
        if (this$timeOut == null ? other$timeOut != null : !((Object)this$timeOut).equals(other$timeOut)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$traceSpanId = this.getTraceSpanId();
        String other$traceSpanId = other.getTraceSpanId();
        return !(this$traceSpanId == null ? other$traceSpanId != null : !this$traceSpanId.equals(other$traceSpanId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startNano = this.getStartNano();
        result = result * 59 + (int)($startNano >>> 32 ^ $startNano);
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $bodyJson = this.getBodyJson();
        result = result * 59 + ($bodyJson == null ? 43 : $bodyJson.hashCode());
        ConnectionSettings $connectionSettings = this.getConnectionSettings();
        result = result * 59 + ($connectionSettings == null ? 43 : $connectionSettings.hashCode());
        String $faultTolerantScope = this.getFaultTolerantScope();
        result = result * 59 + ($faultTolerantScope == null ? 43 : $faultTolerantScope.hashCode());
        Feature $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : ((Object)((Object)$feature)).hashCode());
        RequestFilter $filterChain = this.getFilterChain();
        result = result * 59 + ($filterChain == null ? 43 : $filterChain.hashCode());
        FormBody $formBody = this.getFormBody();
        result = result * 59 + ($formBody == null ? 43 : $formBody.hashCode());
        SingleValueMap<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Consumer<RESP> $onComplete = this.getOnComplete();
        result = result * 59 + ($onComplete == null ? 43 : $onComplete.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        PreferredResponseBodyType $preferredResponseBodyType = this.getPreferredResponseBodyType();
        result = result * 59 + ($preferredResponseBodyType == null ? 43 : ((Object)((Object)$preferredResponseBodyType)).hashCode());
        Function<RESP, Object> $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        SingleValueMap<String, String> $queryStringParams = this.getQueryStringParams();
        result = result * 59 + ($queryStringParams == null ? 43 : ((Object)$queryStringParams).hashCode());
        Duration $timeOut = this.timeOut;
        result = result * 59 + ($timeOut == null ? 43 : ((Object)$timeOut).hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $traceSpanId = this.getTraceSpanId();
        result = result * 59 + ($traceSpanId == null ? 43 : $traceSpanId.hashCode());
        return result;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public Object getBody() {
        return this.body;
    }

    @Generated
    public void setBody(Object body) {
        this.body = body;
    }

    @Generated
    public String getBodyJson() {
        return this.bodyJson;
    }

    @Generated
    public void setBodyJson(String bodyJson) {
        this.bodyJson = bodyJson;
    }

    @Generated
    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    @Generated
    public void setConnectionSettings(ConnectionSettings connectionSettings) {
        this.connectionSettings = connectionSettings;
    }

    @Generated
    public String getFaultTolerantScope() {
        return this.faultTolerantScope;
    }

    @Generated
    public void setFaultTolerantScope(String faultTolerantScope) {
        this.faultTolerantScope = faultTolerantScope;
    }

    @Generated
    public Feature getFeature() {
        return this.feature;
    }

    @Generated
    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    @Generated
    public RequestFilter getFilterChain() {
        return this.filterChain;
    }

    @Generated
    public void setFilterChain(RequestFilter filterChain) {
        this.filterChain = filterChain;
    }

    @Generated
    public FormBody getFormBody() {
        return this.formBody;
    }

    @Generated
    public void setFormBody(FormBody formBody) {
        this.formBody = formBody;
    }

    @Generated
    public SingleValueMap<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public void setMethod(String method) {
        this.method = method;
    }

    @Generated
    public Consumer<RESP> getOnComplete() {
        return this.onComplete;
    }

    @Generated
    public void setOnComplete(Consumer<RESP> onComplete) {
        this.onComplete = onComplete;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public PreferredResponseBodyType getPreferredResponseBodyType() {
        return this.preferredResponseBodyType;
    }

    @Generated
    public void setPreferredResponseBodyType(PreferredResponseBodyType preferredResponseBodyType) {
        this.preferredResponseBodyType = preferredResponseBodyType;
    }

    @Generated
    public Function<RESP, Object> getProcessor() {
        return this.processor;
    }

    @Generated
    public void setProcessor(Function<RESP, Object> processor) {
        this.processor = processor;
    }

    @Generated
    public SingleValueMap<String, String> getQueryStringParams() {
        return this.queryStringParams;
    }

    @Generated
    public void setQueryStringParams(SingleValueMap<String, String> queryStringParams) {
        this.queryStringParams = queryStringParams;
    }

    @Generated
    public long getStartNano() {
        return this.startNano;
    }

    @Generated
    public void setTimeOut(Duration timeOut) {
        this.timeOut = timeOut;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    public String getTraceSpanId() {
        return this.traceSpanId;
    }

    @Generated
    public void setTraceSpanId(String traceSpanId) {
        this.traceSpanId = traceSpanId;
    }

    public static enum PreferredResponseBodyType {
        INFERRED_FROM_CONTENT_TYPE,
        STRING,
        RAW,
        STRING_AND_RAW;

    }
}

