/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.connect;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mx.path.core.common.collection.MultiValueMap;
import com.mx.path.core.common.collection.MultiValueMappable;
import com.mx.path.core.common.collection.SingleValueMap;
import com.mx.path.core.common.connect.Request;
import com.mx.path.core.common.connect.ResponseProcessingException;
import com.mx.path.core.common.exception.PathRequestException;
import com.mx.path.core.common.http.HttpStatus;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;

public abstract class Response<REQ extends Request<?, ?>, RESP extends Response<?, ?>> {
    @Deprecated
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
    private String body = "";
    private MultiValueMap<String, String> cookies = new MultiValueMap();
    private Duration duration;
    private Exception exception;
    private MultiValueMap<String, String> headers = new MultiValueMap();
    private Object object;
    private byte[] rawBody;
    private Request<?, ?> request;
    private HttpStatus status;

    public final void finish() {
        if (this.duration == null) {
            this.request.start();
            long endNano = System.nanoTime();
            this.withDuration(Duration.ofNanos(endNano - this.request.getStartNano()));
        }
    }

    @Deprecated
    public final <T> T getBodyAs(Class<T> asClass) {
        return (T)GSON.fromJson(this.body, asClass);
    }

    public final SingleValueMap<String, String> getCookies() {
        return this.cookies.toSingleValueMap();
    }

    public final SingleValueMap<String, String> getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return this.headers.toSingleValueMap();
    }

    public final MultiValueMap<String, String> getHeadersAsMultiValueMap() {
        return this.headers;
    }

    public final SingleValueMap<String, String> getHeadersAsSingleValueMap() {
        return this.headers.toSingleValueMap();
    }

    public final <T> T getObject(Class<T> klass) {
        return klass.isInstance(this.object) ? (T)klass.cast(this.object) : null;
    }

    public final <T> T getObject() {
        return (T)this.object;
    }

    public final byte[] getRawBody() {
        return (byte[])this.rawBody.clone();
    }

    public final <R extends Request<?, ?>> R getRequest() {
        return (R)this.request;
    }

    public final boolean hasBody() {
        return this.body != null && this.body.length() > 0;
    }

    public final boolean hasRawBody() {
        return this.rawBody != null && this.rawBody.length > 0;
    }

    public final void setHeaders(MultiValueMappable<String, String> multiValueMappable) {
        this.headers = new MultiValueMap<String, String>(multiValueMappable);
    }

    public final RESP throwException() {
        if (Objects.nonNull(this.exception)) {
            if (this.exception instanceof PathRequestException) {
                throw (PathRequestException)this.exception;
            }
            throw new ResponseProcessingException(this.exception);
        }
        return (RESP)this;
    }

    public final RESP withBody(String newBody) {
        this.setBody(newBody);
        return (RESP)this;
    }

    public final RESP withCookies(MultiValueMappable<String, String> newCookies) {
        this.cookies = new MultiValueMap<String, String>(newCookies);
        return (RESP)this;
    }

    public final RESP withDuration(Duration newDuration) {
        this.duration = newDuration;
        return (RESP)this;
    }

    public final RESP withException(Exception newException) {
        this.exception = newException;
        return (RESP)this;
    }

    public final RESP withHeaders(MultiValueMap<String, String> newHeaders) {
        this.headers = newHeaders;
        return (RESP)this;
    }

    public final RESP withObject(Object newObject) {
        this.object = newObject;
        return (RESP)this;
    }

    public final RESP withRawData(byte[] newRawBody) {
        this.rawBody = (byte[])newRawBody.clone();
        return (RESP)this;
    }

    public final RESP withRequest(Request<?, ?> newRequest) {
        this.request = newRequest;
        return (RESP)this;
    }

    public final RESP withStatus(HttpStatus newStatus) {
        this.status = newStatus;
        return (RESP)this;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    @Generated
    public Exception getException() {
        return this.exception;
    }

    @Generated
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Generated
    public void setRawBody(byte[] rawBody) {
        this.rawBody = rawBody;
    }

    @Generated
    public HttpStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(HttpStatus status) {
        this.status = status;
    }
}

