/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.exception;

import com.mx.path.core.common.accessor.PathResponseStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public abstract class PathRequestException
extends RuntimeException {
    private String code;
    private String errorTitle;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String message = "Unknown error";
    private String reason;
    private boolean report = true;
    private PathResponseStatus status = PathResponseStatus.INTERNAL_ERROR;
    private String userMessage;

    public PathRequestException() {
        this("Unknown error");
    }

    public PathRequestException(String message) {
        super(message);
        this.setMessage(message);
    }

    public PathRequestException(Throwable cause) {
        super(cause);
    }

    public PathRequestException(String message, Throwable cause) {
        super(message, cause);
        this.setMessage(message);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public final PathRequestException withCode(String newCode) {
        this.setCode(newCode);
        return this;
    }

    public final PathRequestException withErrorTitle(String newErrorTitle) {
        this.setErrorTitle(newErrorTitle);
        return this;
    }

    public final PathRequestException withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public final PathRequestException withMessage(String newMessage) {
        this.setMessage(newMessage);
        return this;
    }

    public final PathRequestException withReason(String newReason) {
        this.setReason(newReason);
        return this;
    }

    public final PathRequestException withReport(boolean shouldReport) {
        this.setReport(shouldReport);
        return this;
    }

    public final PathRequestException withStatus(PathResponseStatus newStatus) {
        this.setStatus(newStatus);
        return this;
    }

    public final PathRequestException withUserMessage(String newUserMessage) {
        this.setUserMessage(newUserMessage);
        return this;
    }

    public final boolean shouldReport() {
        return this.report;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public String getErrorTitle() {
        return this.errorTitle;
    }

    @Generated
    public void setErrorTitle(String errorTitle) {
        this.errorTitle = errorTitle;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setReport(boolean report) {
        this.report = report;
    }

    @Generated
    public PathResponseStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(PathResponseStatus status) {
        this.status = status;
    }

    @Generated
    public String getUserMessage() {
        return this.userMessage;
    }

    @Generated
    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }
}

