/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.http;

import com.mx.path.core.common.accessor.PathResponseStatus;
import com.mx.path.core.common.configuration.InvalidStateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum HttpStatus {
    CONTINUE(100, "Continue"),
    SWITCHING_PROTOCOLS(101, "Switching Protocols"),
    PROCESSING(102, "Processing"),
    CHECKPOINT(103, "Checkpoint"),
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
    NO_CONTENT(204, "No Content"),
    RESET_CONTENT(205, "Reset Content"),
    PARTIAL_CONTENT(206, "Partial Content"),
    MULTI_STATUS(207, "Multi-Status"),
    ALREADY_REPORTED(208, "Already Reported"),
    IM_USED(226, "IM Used"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    FOUND(302, "Found"),
    MOVED_TEMPORARILY(302, "Moved Temporarily"),
    SEE_OTHER(303, "See Other"),
    NOT_MODIFIED(304, "Not Modified"),
    USE_PROXY(305, "Use Proxy"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    PERMANENT_REDIRECT(308, "Permanent Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    CONFLICT(409, "Conflict"),
    GONE(410, "Gone"),
    LENGTH_REQUIRED(411, "Length Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    URI_TOO_LONG(414, "URI Too Long"),
    REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested range not satisfiable"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    I_AM_A_TEAPOT(418, "I'm a teapot"),
    INSUFFICIENT_SPACE_ON_RESOURCE(419, "Insufficient Space On Resource"),
    METHOD_FAILURE(420, "Method Failure"),
    DESTINATION_LOCKED(421, "Destination Locked"),
    UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
    LOCKED(423, "Locked"),
    FAILED_DEPENDENCY(424, "Failed Dependency"),
    TOO_EARLY(425, "Too Early"),
    UPGRADE_REQUIRED(426, "Upgrade Required"),
    PRECONDITION_REQUIRED(428, "Precondition Required"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
    UNAVAILABLE_FOR_LEGAL_REASONS(451, "Unavailable For Legal Reasons"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version not supported"),
    VARIANT_ALSO_NEGOTIATES(506, "Variant Also Negotiates"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
    LOOP_DETECTED(508, "Loop Detected"),
    BANDWIDTH_LIMIT_EXCEEDED(509, "Bandwidth Limit Exceeded"),
    NOT_EXTENDED(510, "Not Extended"),
    NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required"),
    UPSTREAM_SERVICE_UNAVAILABLE(531, "Upstream Service Unavailable");

    private final int value;
    private final String reasonPhrase;
    private static final Map<HttpStatus, PathResponseStatus> HTTP_STATUS_PATH_RESPONSE_STATUS_MAP;

    private HttpStatus(int value, String reasonPhrase) {
        this.value = value;
        this.reasonPhrase = reasonPhrase;
    }

    public int value() {
        return this.value;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Series series() {
        return Series.valueOf(this);
    }

    public boolean is1xxInformational() {
        return this.series() == Series.INFORMATIONAL;
    }

    public boolean is2xxSuccessful() {
        return this.series() == Series.SUCCESSFUL;
    }

    public boolean is3xxRedirection() {
        return this.series() == Series.REDIRECTION;
    }

    public boolean is4xxClientError() {
        return this.series() == Series.CLIENT_ERROR;
    }

    public boolean is5xxServerError() {
        return this.series() == Series.SERVER_ERROR;
    }

    public boolean isError() {
        return this.is4xxClientError() || this.is5xxServerError();
    }

    public String toString() {
        return this.value + " " + this.name();
    }

    public PathResponseStatus toPathResponseStatus(PathResponseStatus defaultStatus) {
        PathResponseStatus resolved = PathResponseStatus.resolve(this.value());
        if (resolved == null) {
            return defaultStatus;
        }
        return resolved;
    }

    public PathResponseStatus toPathResponseStatus() {
        PathResponseStatus resolved = PathResponseStatus.resolve(this.value());
        if (resolved == null) {
            resolved = HTTP_STATUS_PATH_RESPONSE_STATUS_MAP.get((Object)this);
        }
        return resolved;
    }

    public static HttpStatus valueOf(int statusCode) {
        HttpStatus status = HttpStatus.resolve(statusCode);
        if (status == null) {
            throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
        }
        return status;
    }

    @Nullable
    public static HttpStatus resolve(int statusCode) {
        for (HttpStatus status : HttpStatus.values()) {
            if (status.value != statusCode) continue;
            return status;
        }
        return null;
    }

    static {
        HashMap<HttpStatus, PathResponseStatus> map = new HashMap<HttpStatus, PathResponseStatus>();
        map.put(CONTINUE, PathResponseStatus.UNAVAILABLE);
        map.put(SWITCHING_PROTOCOLS, PathResponseStatus.UNAVAILABLE);
        map.put(PROCESSING, PathResponseStatus.OK);
        map.put(CHECKPOINT, PathResponseStatus.UNAVAILABLE);
        map.put(OK, PathResponseStatus.OK);
        map.put(CREATED, PathResponseStatus.OK);
        map.put(ACCEPTED, PathResponseStatus.ACCEPTED);
        map.put(NON_AUTHORITATIVE_INFORMATION, PathResponseStatus.UNAVAILABLE);
        map.put(NO_CONTENT, PathResponseStatus.NO_CONTENT);
        map.put(RESET_CONTENT, PathResponseStatus.UNAVAILABLE);
        map.put(PARTIAL_CONTENT, PathResponseStatus.UNAVAILABLE);
        map.put(MULTI_STATUS, PathResponseStatus.UNAVAILABLE);
        map.put(ALREADY_REPORTED, PathResponseStatus.UNAVAILABLE);
        map.put(IM_USED, PathResponseStatus.UNAVAILABLE);
        map.put(MULTIPLE_CHOICES, PathResponseStatus.UNAVAILABLE);
        map.put(MOVED_PERMANENTLY, PathResponseStatus.NOT_FOUND);
        map.put(FOUND, PathResponseStatus.OK);
        map.put(MOVED_TEMPORARILY, PathResponseStatus.NOT_FOUND);
        map.put(SEE_OTHER, PathResponseStatus.UNAVAILABLE);
        map.put(NOT_MODIFIED, PathResponseStatus.UNAVAILABLE);
        map.put(USE_PROXY, PathResponseStatus.UNAVAILABLE);
        map.put(TEMPORARY_REDIRECT, PathResponseStatus.UNAVAILABLE);
        map.put(PERMANENT_REDIRECT, PathResponseStatus.UNAVAILABLE);
        map.put(BAD_REQUEST, PathResponseStatus.BAD_REQUEST);
        map.put(UNAUTHORIZED, PathResponseStatus.UNAUTHORIZED);
        map.put(PAYMENT_REQUIRED, PathResponseStatus.UNAUTHORIZED);
        map.put(FORBIDDEN, PathResponseStatus.NOT_ALLOWED);
        map.put(NOT_FOUND, PathResponseStatus.NOT_FOUND);
        map.put(METHOD_NOT_ALLOWED, PathResponseStatus.NOT_ALLOWED);
        map.put(NOT_ACCEPTABLE, PathResponseStatus.USER_ERROR);
        map.put(PROXY_AUTHENTICATION_REQUIRED, PathResponseStatus.UNAUTHORIZED);
        map.put(REQUEST_TIMEOUT, PathResponseStatus.TIMEOUT);
        map.put(CONFLICT, PathResponseStatus.NOT_ALLOWED);
        map.put(GONE, PathResponseStatus.NOT_FOUND);
        map.put(LENGTH_REQUIRED, PathResponseStatus.BAD_REQUEST);
        map.put(PRECONDITION_FAILED, PathResponseStatus.USER_ERROR);
        map.put(PAYLOAD_TOO_LARGE, PathResponseStatus.BAD_REQUEST);
        map.put(REQUEST_ENTITY_TOO_LARGE, PathResponseStatus.BAD_REQUEST);
        map.put(URI_TOO_LONG, PathResponseStatus.BAD_REQUEST);
        map.put(REQUEST_URI_TOO_LONG, PathResponseStatus.BAD_REQUEST);
        map.put(UNSUPPORTED_MEDIA_TYPE, PathResponseStatus.BAD_REQUEST);
        map.put(REQUESTED_RANGE_NOT_SATISFIABLE, PathResponseStatus.USER_ERROR);
        map.put(EXPECTATION_FAILED, PathResponseStatus.USER_ERROR);
        map.put(I_AM_A_TEAPOT, PathResponseStatus.OK);
        map.put(INSUFFICIENT_SPACE_ON_RESOURCE, PathResponseStatus.INTERNAL_ERROR);
        map.put(METHOD_FAILURE, PathResponseStatus.INTERNAL_ERROR);
        map.put(DESTINATION_LOCKED, PathResponseStatus.NOT_ALLOWED);
        map.put(UNPROCESSABLE_ENTITY, PathResponseStatus.USER_ERROR);
        map.put(LOCKED, PathResponseStatus.NOT_ALLOWED);
        map.put(FAILED_DEPENDENCY, PathResponseStatus.USER_ERROR);
        map.put(TOO_EARLY, PathResponseStatus.NOT_ALLOWED);
        map.put(UPGRADE_REQUIRED, PathResponseStatus.USER_ERROR);
        map.put(PRECONDITION_REQUIRED, PathResponseStatus.USER_ERROR);
        map.put(TOO_MANY_REQUESTS, PathResponseStatus.TOO_MANY_REQUESTS);
        map.put(REQUEST_HEADER_FIELDS_TOO_LARGE, PathResponseStatus.BAD_REQUEST);
        map.put(UNAVAILABLE_FOR_LEGAL_REASONS, PathResponseStatus.NOT_ALLOWED);
        map.put(INTERNAL_SERVER_ERROR, PathResponseStatus.INTERNAL_ERROR);
        map.put(NOT_IMPLEMENTED, PathResponseStatus.NOT_IMPLEMENTED);
        map.put(BAD_GATEWAY, PathResponseStatus.UNAVAILABLE);
        map.put(SERVICE_UNAVAILABLE, PathResponseStatus.UNAVAILABLE);
        map.put(GATEWAY_TIMEOUT, PathResponseStatus.TIMEOUT);
        map.put(HTTP_VERSION_NOT_SUPPORTED, PathResponseStatus.BAD_REQUEST);
        map.put(VARIANT_ALSO_NEGOTIATES, PathResponseStatus.NOT_ALLOWED);
        map.put(INSUFFICIENT_STORAGE, PathResponseStatus.INTERNAL_ERROR);
        map.put(LOOP_DETECTED, PathResponseStatus.INTERNAL_ERROR);
        map.put(BANDWIDTH_LIMIT_EXCEEDED, PathResponseStatus.OK);
        map.put(NOT_EXTENDED, PathResponseStatus.INTERNAL_ERROR);
        map.put(NETWORK_AUTHENTICATION_REQUIRED, PathResponseStatus.NOT_ALLOWED);
        map.put(UPSTREAM_SERVICE_UNAVAILABLE, PathResponseStatus.UPSTREAM_SERVICE_UNAVAILABLE);
        map.forEach((httpStatus, pathResponseStatus) -> {
            PathResponseStatus resolved = PathResponseStatus.resolve(httpStatus.value);
            if (resolved != null && resolved != pathResponseStatus) {
                throw new InvalidStateException("HttpStatus to PathResponseStatus mappings incorrect. Value for existing PathResponseStatus(" + pathResponseStatus.name() + ") must match value for mapped HttpStatus(" + httpStatus.name() + ")");
            }
        });
        HTTP_STATUS_PATH_RESPONSE_STATUS_MAP = Collections.unmodifiableMap(map);
    }

    public static enum Series {
        INFORMATIONAL(1),
        SUCCESSFUL(2),
        REDIRECTION(3),
        CLIENT_ERROR(4),
        SERVER_ERROR(5);

        private final int value;

        private Series(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Series valueOf(HttpStatus status) {
            return Series.valueOf(status.value);
        }

        public static Series valueOf(int statusCode) {
            Series series = Series.resolve(statusCode);
            if (series == null) {
                throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
            }
            return series;
        }

        @Nullable
        public static Series resolve(int statusCode) {
            int seriesCode = statusCode / 100;
            for (Series series : Series.values()) {
                if (series.value != seriesCode) continue;
                return series;
            }
            return null;
        }
    }
}

