/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.lang;

import com.mx.path.core.common.configuration.ConfigurationException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Durations {
    private static final String DAYS_MINIMUM_SUFFIX = "d";
    private static final String HOURS_MINIMUM_SUFFIX = "h";
    private static final String MINUTES_MINIMUM_SUFFIX = "min";
    private static final String SECONDS_MINIMUM_SUFFIX = "s";
    private static final String MILLIS_MINIMUM_SUFFIX = "m";
    private static final String NANOS_MINIMUM_SUFFIX = "n";
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(?<value>\\d+)\\s*(?<unit>[a-z]+)$");

    public static Duration fromCompactString(String durationStr) {
        Matcher matcher = DURATION_PATTERN.matcher(durationStr.toString().trim());
        try {
            if (matcher.matches()) {
                long durationValue = Integer.parseInt(matcher.group("value"));
                String durationUnit = matcher.group("unit");
                if (durationUnit.startsWith(DAYS_MINIMUM_SUFFIX)) {
                    return Duration.ofDays(durationValue);
                }
                if (durationUnit.startsWith(HOURS_MINIMUM_SUFFIX)) {
                    return Duration.ofHours(durationValue);
                }
                if (durationUnit.startsWith(MINUTES_MINIMUM_SUFFIX)) {
                    return Duration.ofMinutes(durationValue);
                }
                if (durationUnit.startsWith(MILLIS_MINIMUM_SUFFIX)) {
                    return Duration.ofMillis(durationValue);
                }
                if (durationUnit.startsWith(SECONDS_MINIMUM_SUFFIX)) {
                    return Duration.ofSeconds(durationValue);
                }
                if (durationUnit.startsWith(NANOS_MINIMUM_SUFFIX)) {
                    return Duration.ofNanos(durationValue);
                }
                throw new ConfigurationException("Invalid duration unit: " + durationStr);
            }
            throw new ConfigurationException("Invalid duration string: " + durationStr);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid duration string: " + durationStr, e);
        }
    }

    public static ChronoUnit maxAccurateUnit(Duration duration) {
        Duration reducingDuration = Duration.ofSeconds(duration.getSeconds(), duration.getNano());
        if (reducingDuration.toDays() > 0L && (reducingDuration = reducingDuration.minusDays(duration.toDays())).toNanos() <= 0L) {
            return ChronoUnit.DAYS;
        }
        if (reducingDuration.toHours() > 0L && (reducingDuration = reducingDuration.minusHours(duration.toHours())).toNanos() <= 0L) {
            return ChronoUnit.HOURS;
        }
        if (reducingDuration.toMinutes() > 0L && (reducingDuration = reducingDuration.minusMinutes(duration.toMinutes())).toNanos() <= 0L) {
            return ChronoUnit.MINUTES;
        }
        if (reducingDuration.getSeconds() > 0L && (reducingDuration = reducingDuration.minusSeconds(duration.getSeconds())).toNanos() <= 0L) {
            return ChronoUnit.SECONDS;
        }
        if (reducingDuration.toMillis() > 0L && (reducingDuration = reducingDuration.minusMillis(duration.toMillis())).toNanos() <= 0L) {
            return ChronoUnit.MILLIS;
        }
        return ChronoUnit.NANOS;
    }

    public static String toCompactString(Duration duration) {
        return Durations.toCompactString(duration, Durations.maxAccurateUnit(duration));
    }

    public static String toCompactString(Duration duration, ChronoUnit unit) {
        switch (unit) {
            case DAYS: {
                return duration.toDays() + DAYS_MINIMUM_SUFFIX;
            }
            case HOURS: {
                return duration.toHours() + HOURS_MINIMUM_SUFFIX;
            }
            case MINUTES: {
                return duration.toMinutes() + MINUTES_MINIMUM_SUFFIX;
            }
            case SECONDS: {
                return duration.getSeconds() + SECONDS_MINIMUM_SUFFIX;
            }
            case MILLIS: {
                return duration.toMillis() + MILLIS_MINIMUM_SUFFIX;
            }
        }
        return duration.toNanos() + NANOS_MINIMUM_SUFFIX;
    }
}

