/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.messaging;

import com.mx.path.core.common.http.HttpStatus;

public enum MessageStatus {
    SUCCESS(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NOT_AUTHORIZED(401, "Unauthorized"),
    NOT_FOUND(404, "Not Found"),
    NO_RESPONDER(405, "Method Not Allowed"),
    TIMEOUT(408, "Remote request timeout"),
    FAIL(500, "Remote call failed"),
    INVALID_RESPONDER(502, "Bad Gateway"),
    DISABLED(503, "Service Unavailable");

    private final int value;
    private final String reasonPhrase;

    public static MessageStatus resolve(int statusCode) {
        for (MessageStatus status : MessageStatus.values()) {
            if (status.value != statusCode) continue;
            return status;
        }
        return null;
    }

    public static MessageStatus fromHttpStatus(HttpStatus httpStatus) {
        if (httpStatus != null) {
            return MessageStatus.resolve(httpStatus.value());
        }
        return null;
    }

    private MessageStatus(int value, String reasonPhrase) {
        this.value = value;
        this.reasonPhrase = reasonPhrase;
    }

    public int value() {
        return this.value;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public HttpStatus toHttpStatus() {
        return HttpStatus.resolve(this.value());
    }
}

