/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.model;

import com.google.gson.reflect.TypeToken;
import com.mx.path.core.common.model.ModelBase;
import com.mx.path.core.common.model.ModelWrappable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ModelList<T extends ModelBase<?>>
implements List<T>,
ModelWrappable<ModelList<T>> {
    private static final Map<Class<?>, Class<?>> CACHED_TYPE_TO_LIST_TYPE = new LinkedHashMap();
    private static final Map<Class<?>, Type> CACHED_TYPE_TO_LIST_TYPETOKEN = new LinkedHashMap();
    private transient boolean wrapped = false;
    private final List<T> container = new ArrayList<T>();

    @SuppressFBWarnings(value={"DM_NEW_FOR_GETCLASS"})
    public static <T extends ModelBase<?>> Class<?> ofClass(Class<T> klass) {
        if (!CACHED_TYPE_TO_LIST_TYPE.containsKey(klass)) {
            CACHED_TYPE_TO_LIST_TYPE.put(klass, ModelList.class);
        }
        return CACHED_TYPE_TO_LIST_TYPE.get(klass);
    }

    public static <T extends ModelBase<?>> Type ofTypeToken(Class<T> klass) {
        if (!CACHED_TYPE_TO_LIST_TYPETOKEN.containsKey(klass)) {
            CACHED_TYPE_TO_LIST_TYPETOKEN.put(klass, new TypeToken<T>(){}.getType());
        }
        return CACHED_TYPE_TO_LIST_TYPETOKEN.get(klass);
    }

    public ModelList() {
    }

    public ModelList(List<? extends T> copyList) {
        this.container.addAll(copyList);
    }

    @Override
    public final int size() {
        return this.container.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.container.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.container.contains(o);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.container.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.container.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.container.toArray(a);
    }

    @Override
    public final boolean add(T e) {
        return this.container.add(e);
    }

    @Override
    public final boolean remove(Object o) {
        return this.container.remove(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.container.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        return this.container.addAll(c);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends T> c) {
        return this.container.addAll(index, c);
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.container.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.container.retainAll(c);
    }

    @Override
    public final void clear() {
        this.container.clear();
    }

    @Override
    public final T get(int index) {
        return (T)((ModelBase)this.container.get(index));
    }

    @Override
    public final T set(int index, T element) {
        return (T)((ModelBase)this.container.set(index, element));
    }

    @Override
    public final void add(int index, T element) {
        this.container.add(index, element);
    }

    @Override
    public final T remove(int index) {
        return (T)((ModelBase)this.container.remove(index));
    }

    @Override
    public final int indexOf(Object o) {
        return this.container.indexOf(o);
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.container.lastIndexOf(o);
    }

    @Override
    public final ListIterator<T> listIterator() {
        return this.container.listIterator();
    }

    @Override
    public final ListIterator<T> listIterator(int index) {
        return this.container.listIterator();
    }

    @Override
    public final List<T> subList(int fromIndex, int toIndex) {
        return this.container.subList(fromIndex, toIndex);
    }

    @Override
    public ModelList<T> wrapped() {
        this.setWrapped(true);
        return this;
    }

    @Override
    public final boolean getWrapped() {
        return this.wrapped;
    }

    @Override
    public final void setWrapped(boolean newWrapped) {
        this.wrapped = newWrapped;
    }
}

