/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class Annotations {
    public static List<FieldWithAnnotations> fieldsWithAnnotations(Class<?> klass) {
        return Arrays.stream(klass.getDeclaredFields()).map(field -> {
            FieldWithAnnotations fieldWithAnnotations = new FieldWithAnnotations();
            fieldWithAnnotations.setField((Field)field);
            for (Annotation annotation : field.getAnnotations()) {
                fieldWithAnnotations.putAnnotation(annotation);
            }
            return fieldWithAnnotations;
        }).filter(annotatedField -> !annotatedField.getField().getName().startsWith("$")).collect(Collectors.toList());
    }

    public static <T extends Annotation> List<Method> methodsWithAnnotation(Class<T> annotation, Class<?> klass) {
        return Arrays.stream(klass.getMethods()).filter(method -> method.getAnnotation(annotation) != null).collect(Collectors.toList());
    }

    public static <T extends Annotation> List<AnnotatedField<T>> fieldsWithAnnotation(Class<T> annotationType, Class<?> klass) {
        return Arrays.stream(klass.getDeclaredFields()).map(field -> {
            AnnotatedField annotatedField = new AnnotatedField();
            annotatedField.setAnnotation(field.getAnnotation(annotationType));
            annotatedField.setField((Field)field);
            return annotatedField;
        }).filter(annotatedField -> annotatedField.getAnnotation() != null).collect(Collectors.toList());
    }

    public static <T extends Annotation> boolean hasAnnotation(Class<?> klass, Class<T> annotation) {
        return klass.getAnnotation(annotation) != null;
    }

    public static <T extends Annotation> List<AnnotatedParameter<T>> parametersWithAnnotation(Class<T> annotationType, Constructor<?> constructor) {
        AtomicInteger position = new AtomicInteger();
        return Arrays.stream(constructor.getParameters()).map(parameter -> {
            AnnotatedParameter annotatedField = new AnnotatedParameter();
            annotatedField.setAnnotation(parameter.getAnnotation(annotationType));
            annotatedField.setParameter((Parameter)parameter);
            annotatedField.setPosition(position.getAndIncrement());
            return annotatedField;
        }).filter(annotatedField -> annotatedField.getAnnotation() != null).collect(Collectors.toList());
    }

    public static Class<? extends Annotation> resolveAnnotationType(Annotation annotation) {
        if (annotation instanceof Proxy) {
            return annotation.annotationType();
        }
        return annotation.getClass();
    }

    public static class AnnotatedParameter<T extends Annotation> {
        private T annotation;
        private Parameter parameter;
        private int position;

        public final T getAnnotation() {
            return this.annotation;
        }

        public final void setAnnotation(T annotation) {
            this.annotation = annotation;
        }

        public final Parameter getParameter() {
            return this.parameter;
        }

        public final void setParameter(Parameter parameter) {
            this.parameter = parameter;
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int position) {
            this.position = position;
        }
    }

    public static class AnnotatedField<T extends Annotation> {
        private T annotation;
        private Class<?> elementType;
        private Field field;

        public final void setAnnotation(T annotation) {
            this.annotation = annotation;
        }

        public final T getAnnotation() {
            return this.annotation;
        }

        public final void setElementType(Type elementType) {
            this.elementType = (Class)elementType;
        }

        public final void setElementType(Class<?> elementType) {
            this.elementType = elementType;
        }

        public final Class<?> getElementType() {
            return this.elementType;
        }

        public final void setField(Field field) {
            this.field = field;
        }

        public final Field getField() {
            return this.field;
        }
    }

    public static class FieldWithAnnotations {
        private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
        private Class<?> elementType;
        private Field field;

        public final void setElementType(Class<?> elementType) {
            this.elementType = elementType;
        }

        public final Class<?> getElementType() {
            return this.elementType;
        }

        public final void setField(Field field) {
            this.field = field;
        }

        public final Field getField() {
            return this.field;
        }

        public final <T extends Annotation> AnnotatedField<T> asAnnotatedField(Class<T> annotationType) {
            AnnotatedField<T> annotatedField = new AnnotatedField<T>();
            annotatedField.setAnnotation(this.getAnnotation(annotationType));
            annotatedField.setField(this.getField());
            annotatedField.setElementType(this.getElementType());
            return annotatedField;
        }

        public final void putAnnotation(Annotation annotation) {
            this.annotations.put(Annotations.resolveAnnotationType(annotation), annotation);
        }

        public final <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return (T)this.annotations.get(annotationType);
        }
    }
}

