/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class Constructors {
    public static <T> Constructor<T> getNoArgumentConstructor(Class<T> klass) {
        Constructor<?>[] constructors = klass.getDeclaredConstructors();
        return Arrays.stream(constructors).filter(constructor -> constructor.getParameterCount() == 0).findFirst().orElse(null);
    }

    public static <T> T instantiateWithNoArgumentConstructor(Class<T> klass) {
        Constructor<T> constructor = Constructors.getNoArgumentConstructor(klass);
        if (constructor == null) {
            throw new RuntimeException("No default constructor exists for " + klass);
        }
        boolean originalAccessibility = constructor.isAccessible();
        try {
            T t;
            constructor.setAccessible(true);
            try {
                t = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Error constructing " + klass);
            }
            return t;
        }
        finally {
            constructor.setAccessible(originalAccessibility);
        }
    }
}

