/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.reflection;

import com.mx.path.core.common.configuration.ConfigurationException;
import com.mx.path.core.common.lang.Durations;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

public class Fields {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(Field field, Object obj) {
        boolean originalAccessibility = field.isAccessible();
        field.setAccessible(true);
        try {
            Object object = field.get(obj);
            field.setAccessible(originalAccessibility);
            return object;
        }
        catch (Throwable throwable) {
            try {
                field.setAccessible(originalAccessibility);
                throw throwable;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Can't get field value " + field.getName(), e);
            }
        }
    }

    public static Object getFieldValue(String fieldName, Object obj) {
        Field field = Arrays.stream(obj.getClass().getDeclaredFields()).filter(f -> Objects.equals(f.getName(), fieldName)).findFirst().orElse(null);
        if (field != null) {
            return Fields.getFieldValue(field, obj);
        }
        throw new RuntimeException("Can't find field " + fieldName + " on " + obj.getClass().getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Field field, Object obj, Object val) {
        try {
            boolean originalAccessibility = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(obj, Fields.coerceValueType(field.getType(), val));
            }
            finally {
                field.setAccessible(originalAccessibility);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Can't set field value " + field.getName(), e);
        }
    }

    public static void setFieldValue(String fieldName, Object obj, Object val) {
        Field field = Arrays.stream(obj.getClass().getDeclaredFields()).filter(f -> Objects.equals(f.getName(), fieldName)).findFirst().orElse(null);
        if (field == null) {
            throw new RuntimeException("Can't find field " + fieldName + " on " + obj.getClass().getCanonicalName());
        }
        Fields.setFieldValue(field, obj, val);
    }

    private static Object coerceValueType(Class<?> targetType, Object value) {
        if (value == null) {
            return null;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return Integer.valueOf(value.toString().trim());
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(value.toString().trim());
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return Double.valueOf(value.toString().trim());
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return Long.valueOf(value.toString().trim());
        }
        if (targetType == String.class) {
            return value.toString();
        }
        if (targetType == Duration.class) {
            return Fields.coerceToDuration(value);
        }
        if (targetType.isEnum()) {
            return Fields.coerceToEnum(targetType, value);
        }
        return value;
    }

    private static Duration coerceToDuration(Object value) {
        if (value.getClass() != String.class) {
            throw new ConfigurationException("Duration value must be a string");
        }
        return Durations.fromCompactString(value.toString());
    }

    private static Enum<? extends Enum<?>> coerceToEnum(Class<?> targetType, Object value) {
        String valueStr = value.toString().trim();
        EnumSet<?> enumValues = EnumSet.allOf(targetType);
        return enumValues.stream().filter(enumValue -> valueStr.equalsIgnoreCase(enumValue.toString()) || valueStr.equalsIgnoreCase(enumValue.name())).findFirst().orElseThrow(() -> new ConfigurationException("Invalid value " + valueStr + " for enumeration " + targetType.getName()));
    }
}

