/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogValueMasker {
    private static final String MASK = "**MASKED**";
    private static final String[] HEADERKEYS = new String[]{"x-csrf-token", "x-request-token", "asp.net_sessionid", "mx-session-key"};
    private static final String[] PAYLOADPATTERNS = new String[]{"`antiforgerytoken`\\s*:\\s*`([^`]+)`".replaceAll("`", "\\\\\""), "`token`\\s*:\\s*`([^`]+)`".replaceAll("`", "\\\\\""), "`password`\\s*:\\s*`([^`]+)`".replaceAll("`", "\\\\\"")};
    private static final HashSet<String> HEADERKEYSET = new HashSet();
    private static final List<Pattern> PAYLOADPATTERNSET = new ArrayList<Pattern>();
    private static final List<Pattern> COOKIEPATTERNSET = new ArrayList<Pattern>();

    public static void registerCookieKey(String key) {
        COOKIEPATTERNSET.add(Pattern.compile(key.toLowerCase(Locale.ENGLISH) + "=([^;]+)", 2));
    }

    public static void registerHeaderKey(String key) {
        HEADERKEYSET.add(key.toLowerCase(Locale.ENGLISH));
    }

    public static void registerPayloadPattern(String pattern) {
        Pattern mask = Pattern.compile(pattern, 2);
        PAYLOADPATTERNSET.add(mask);
    }

    public static void resetPatterns() {
        HEADERKEYSET.clear();
        PAYLOADPATTERNSET.clear();
        COOKIEPATTERNSET.clear();
        Collections.addAll(HEADERKEYSET, HEADERKEYS);
        for (String pattern : PAYLOADPATTERNS) {
            LogValueMasker.registerPayloadPattern(pattern);
        }
    }

    public static void clearPatterns() {
        HEADERKEYSET.clear();
        PAYLOADPATTERNSET.clear();
        COOKIEPATTERNSET.clear();
    }

    public final String maskHeaderValue(String header, String value) {
        if (header.contains("Cookie") || header.contains("Set-Cookie")) {
            return this.applyPatternsToPayload(value, COOKIEPATTERNSET);
        }
        if (HEADERKEYSET.contains(header.toLowerCase(Locale.ENGLISH))) {
            return MASK;
        }
        return value;
    }

    public final String maskPayload(String payload) {
        return this.applyPatternsToPayload(payload, PAYLOADPATTERNSET);
    }

    private String applyPatternsToPayload(String payload, List<Pattern> patterns) {
        for (Pattern p : patterns) {
            Matcher m = p.matcher(payload);
            int start = 0;
            while (m.find(start)) {
                String patternMatch = m.group();
                for (int i = 1; i <= m.groupCount(); ++i) {
                    if (m.group(i) == null) continue;
                    patternMatch = patternMatch.replace(m.group(i), MASK);
                }
                payload = payload.replace(m.group(), patternMatch);
                start = m.start() + 1;
            }
        }
        return payload;
    }

    static {
        LogValueMasker.resetPatterns();
    }
}

