/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mx.path.core.common.configuration.ConfigurationField;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.reflection.Fields;
import com.mx.path.core.common.serialization.DurationTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class ConfigurationTypeAdapter<ST>
extends TypeAdapter<ST> {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new Factory()).create();
    private final TypeAdapter<ST> delegate;

    public ConfigurationTypeAdapter(TypeAdapter<ST> delegate) {
        this.delegate = delegate;
    }

    public final void write(JsonWriter out, ST value) throws IOException {
        out.beginObject();
        for (Field field : value.getClass().getDeclaredFields()) {
            ConfigurationField annotation = field.getDeclaredAnnotation(ConfigurationField.class);
            if (annotation == null) continue;
            this.writeValue(out, field, value, annotation);
        }
        out.endObject();
    }

    public final ST read(JsonReader in) throws IOException {
        return (ST)this.delegate.read(in);
    }

    private boolean isSecretList(Field field, ConfigurationField annotation) {
        return List.class.isAssignableFrom(field.getType()) && annotation.secret() && annotation.elementType() == String.class;
    }

    private void writeValue(JsonWriter out, Field field, ST value, ConfigurationField annotation) throws IOException {
        String name;
        String string = name = Strings.isNotBlank(annotation.value()) ? annotation.value() : field.getName();
        if (field.getType() == String.class) {
            this.renderString(out, field, value, annotation, name);
        } else if (this.isSecretList(field, annotation)) {
            this.renderSecretList(out, field, value, name);
        } else {
            this.renderOtherNonSecret(out, field, value, annotation, name);
        }
    }

    private void renderOtherNonSecret(JsonWriter out, Field field, ST value, ConfigurationField annotation, String name) throws IOException {
        if (!annotation.secret()) {
            JsonElement element = GSON.toJsonTree(Fields.getFieldValue(field, value));
            out.name(name);
            GSON.toJson(element, out);
        }
    }

    private void renderSecretList(JsonWriter out, Field field, ST value, String name) throws IOException {
        List list = (List)Fields.getFieldValue(field, value);
        if (list != null) {
            out.name(name).beginArray();
            for (int i = 0; i < list.size(); ++i) {
                out.value("****");
            }
            out.endArray();
        }
    }

    private void renderString(JsonWriter out, Field field, ST value, ConfigurationField annotation, String name) throws IOException {
        if (annotation.secret()) {
            String strValue = (String)Fields.getFieldValue(field, value);
            out.name(name).value(strValue == null ? null : (Strings.isBlank(strValue) ? "" : "****"));
        } else {
            out.name(name).value((String)Fields.getFieldValue(field, value));
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() == Duration.class) {
                return new DurationTypeAdapter();
            }
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            if (Arrays.stream(type.getRawType().getDeclaredFields()).anyMatch(field -> field.isAnnotationPresent(ConfigurationField.class))) {
                return new ConfigurationTypeAdapter(delegate);
            }
            return null;
        }
    }
}

