/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.serialization.LocalDateJava8;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class LocalDateDeserializer
implements JsonDeserializer<LocalDate>,
JsonSerializer<LocalDate> {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd";
    private static final List<DateTimeFormatter> DEFAULT_FORMAT_STRINGS;
    private static final Gson GSON;
    private List<DateTimeFormatter> formats;
    private String serializeFormat;

    public final LocalDate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            LocalDateJava8 localDateJava8 = (LocalDateJava8)GSON.fromJson(json, LocalDateJava8.class);
            return localDateJava8.toLocalDate();
        }
        JsonPrimitive dateJson = json.getAsJsonPrimitive();
        if (dateJson.isJsonNull()) {
            return null;
        }
        String localDateStr = dateJson.getAsString();
        for (DateTimeFormatter s : this.formats.isEmpty() ? DEFAULT_FORMAT_STRINGS : this.formats) {
            try {
                return LocalDate.parse(localDateStr, s);
            }
            catch (DateTimeParseException e) {
            }
        }
        throw new JsonParseException("Invalid date: " + localDateStr);
    }

    public final JsonElement serialize(LocalDate src, Type typeOfSrc, JsonSerializationContext context) {
        if (Strings.isBlank(this.serializeFormat) || this.serializeFormat.equals("OBJECT")) {
            return GSON.toJsonTree((Object)new LocalDateJava8(src));
        }
        return new JsonPrimitive(src.format(DateTimeFormatter.ofPattern(this.serializeFormat)));
    }

    @Generated
    LocalDateDeserializer(List<DateTimeFormatter> formats, String serializeFormat) {
        this.formats = formats;
        this.serializeFormat = serializeFormat;
    }

    @Generated
    public static LocalDateDeserializerBuilder builder() {
        return new LocalDateDeserializerBuilder();
    }

    static {
        ArrayList<DateTimeFormatter> dateTimeFormatters = new ArrayList<DateTimeFormatter>();
        dateTimeFormatters.add(DateTimeFormatter.ofPattern(DEFAULT_FORMAT));
        DEFAULT_FORMAT_STRINGS = Collections.unmodifiableList(dateTimeFormatters);
        GSON = new Gson();
    }

    public static class LocalDateDeserializerBuilder {
        private List<DateTimeFormatter> formats = new ArrayList<DateTimeFormatter>();
        private String serializeFormat = "OBJECT";

        public final LocalDateDeserializerBuilder format(String format) {
            this.formats.add(DateTimeFormatter.ofPattern(format));
            return this;
        }

        public final LocalDateDeserializerBuilder serializeFormat(String format) {
            this.serializeFormat = format;
            return this;
        }

        @Generated
        LocalDateDeserializerBuilder() {
        }

        @Generated
        public LocalDateDeserializerBuilder formats(List<DateTimeFormatter> formats) {
            this.formats = formats;
            return this;
        }

        @Generated
        public LocalDateDeserializer build() {
            return new LocalDateDeserializer(this.formats, this.serializeFormat);
        }

        @Generated
        public String toString() {
            return "LocalDateDeserializer.LocalDateDeserializerBuilder(formats=" + this.formats + ", serializeFormat=" + this.serializeFormat + ")";
        }
    }
}

