/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.serialization.LocalDateTimeJava8;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class LocalDateTimeDeserializer
implements JsonDeserializer<LocalDateTime>,
JsonSerializer<LocalDateTime> {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final List<DateTimeFormatter> DEFAULT_FORMAT_STRINGS;
    private static final Gson GSON;
    private List<DateTimeFormatter> formats;
    private String serializeFormat;

    public final LocalDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            LocalDateTimeJava8 localDateTimeJava8 = (LocalDateTimeJava8)GSON.fromJson(json, LocalDateTimeJava8.class);
            return localDateTimeJava8.toLocalDateTime();
        }
        JsonPrimitive dateJson = json.getAsJsonPrimitive();
        if (dateJson.isJsonNull()) {
            return null;
        }
        String localDateTimeStr = dateJson.getAsString();
        for (DateTimeFormatter s : this.formats.isEmpty() ? DEFAULT_FORMAT_STRINGS : this.formats) {
            try {
                return LocalDateTime.parse(localDateTimeStr, s);
            }
            catch (DateTimeParseException e) {
            }
        }
        throw new JsonParseException("Invalid dateTime: " + localDateTimeStr);
    }

    public final JsonElement serialize(LocalDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        if (Strings.isBlank(this.serializeFormat) || this.serializeFormat.equals("OBJECT")) {
            return GSON.toJsonTree((Object)new LocalDateTimeJava8(src));
        }
        return new JsonPrimitive(src.format(DateTimeFormatter.ofPattern(this.serializeFormat)));
    }

    @Generated
    LocalDateTimeDeserializer(List<DateTimeFormatter> formats, String serializeFormat) {
        this.formats = formats;
        this.serializeFormat = serializeFormat;
    }

    @Generated
    public static LocalDateTimeDeserializerBuilder builder() {
        return new LocalDateTimeDeserializerBuilder();
    }

    static {
        ArrayList<DateTimeFormatter> dateTimeFormatters = new ArrayList<DateTimeFormatter>();
        dateTimeFormatters.add(DateTimeFormatter.ofPattern(DEFAULT_FORMAT));
        DEFAULT_FORMAT_STRINGS = Collections.unmodifiableList(dateTimeFormatters);
        GSON = new Gson();
    }

    public static class LocalDateTimeDeserializerBuilder {
        private List<DateTimeFormatter> formats = new ArrayList<DateTimeFormatter>();
        private String serializeFormat = "OBJECT";

        public final LocalDateTimeDeserializerBuilder format(String format) {
            this.formats.add(DateTimeFormatter.ofPattern(format));
            return this;
        }

        public final LocalDateTimeDeserializerBuilder serializeFormat(String format) {
            this.serializeFormat = format;
            return this;
        }

        @Generated
        LocalDateTimeDeserializerBuilder() {
        }

        @Generated
        public LocalDateTimeDeserializerBuilder formats(List<DateTimeFormatter> formats) {
            this.formats = formats;
            return this;
        }

        @Generated
        public LocalDateTimeDeserializer build() {
            return new LocalDateTimeDeserializer(this.formats, this.serializeFormat);
        }

        @Generated
        public String toString() {
            return "LocalDateTimeDeserializer.LocalDateTimeDeserializerBuilder(formats=" + this.formats + ", serializeFormat=" + this.serializeFormat + ")";
        }
    }
}

