/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mx.path.core.common.collection.ObjectArray;
import com.mx.path.core.common.collection.ObjectMap;
import java.lang.reflect.Type;

public class ObjectMapJsonDeserializer
implements JsonDeserializer<ObjectMap> {
    public final ObjectMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.toObjectMap(json);
    }

    private ObjectMap toObjectMap(JsonElement json) {
        JsonObject obj = json.getAsJsonObject();
        ObjectMap result = new ObjectMap();
        obj.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonPrimitive()) {
                result.put(name, this.toPrimitive(element));
            } else if (element.isJsonObject()) {
                result.put(name, this.toObjectMap(element));
            } else if (element.isJsonArray()) {
                result.put(name, this.toObjectArray(element));
            }
        });
        return result;
    }

    private ObjectArray toObjectArray(JsonElement json) {
        JsonArray array = json.getAsJsonArray();
        ObjectArray result = new ObjectArray();
        array.forEach(element -> {
            if (element.isJsonPrimitive()) {
                result.add(this.toPrimitive((JsonElement)element));
            } else if (element.isJsonObject()) {
                result.add(this.toObjectMap((JsonElement)element));
            } else if (element.isJsonArray()) {
                result.add(this.toObjectArray((JsonElement)element));
            }
        });
        return result;
    }

    private Object toPrimitive(JsonElement element) {
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            return primitive.getAsBigDecimal();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        return null;
    }
}

