/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.common.serialization;

import com.mx.path.core.common.collection.ObjectArray;
import com.mx.path.core.common.collection.ObjectMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class ObjectMapYamlDeserializer {
    private static final int DEFAULT_MAX_YAML_ALIASES = 50;
    private Parameters parameters;

    public ObjectMapYamlDeserializer() {
        this.parameters = Parameters.builder().build();
    }

    public ObjectMapYamlDeserializer(Parameters parameters) {
        this.parameters = parameters;
    }

    public final Object fromYaml(String document) {
        LoaderOptions options = new LoaderOptions();
        options.setMaxAliasesForCollections(this.getParameters().getMaxYamlAliases());
        Yaml yaml = new Yaml((BaseConstructor)new ObjectMapConstructor(options), new Representer(), new DumperOptions(), options);
        Object root = yaml.load(document);
        if (root instanceof Map) {
            ObjectMap map = new ObjectMap();
            map.putAll((Map)root);
            root = map;
        }
        this.populateObjectMaps(root);
        return root;
    }

    public final String toYaml(Object yaml) {
        return new Yaml().dump(yaml);
    }

    private void populateObjectMaps(Object root) {
        block3: {
            block2: {
                if (!(root instanceof ObjectMap)) break block2;
                ObjectMap map = (ObjectMap)root;
                for (Map.Entry entry : map.entrySet()) {
                    Object converted = this.tryToConvertToObjectMap(entry.getValue());
                    map.put((String)entry.getKey(), converted);
                    this.populateObjectMaps(converted);
                }
                break block3;
            }
            if (!(root instanceof ObjectArray)) break block3;
            ObjectArray array = (ObjectArray)root;
            for (int i = 0; i < array.size(); ++i) {
                Object converted = this.tryToConvertToObjectMap(array.get(i));
                array.set(i, converted);
                this.populateObjectMaps(converted);
            }
        }
    }

    private Object tryToConvertToObjectMap(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            ObjectMap objectMap = new ObjectMap();
            objectMap.putAll(map);
            return objectMap;
        }
        return object;
    }

    @Generated
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public Parameters getParameters() {
        return this.parameters;
    }

    public static class Parameters {
        private int maxYamlAliases;

        @Generated
        private static int $default$maxYamlAliases() {
            return 50;
        }

        @Generated
        Parameters(int maxYamlAliases) {
            this.maxYamlAliases = maxYamlAliases;
        }

        @Generated
        public static ParametersBuilder builder() {
            return new ParametersBuilder();
        }

        @Generated
        public int getMaxYamlAliases() {
            return this.maxYamlAliases;
        }

        @Generated
        public void setMaxYamlAliases(int maxYamlAliases) {
            this.maxYamlAliases = maxYamlAliases;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameters)) {
                return false;
            }
            Parameters other = (Parameters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxYamlAliases() == other.getMaxYamlAliases();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Parameters;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxYamlAliases();
            return result;
        }

        @Generated
        public String toString() {
            return "ObjectMapYamlDeserializer.Parameters(maxYamlAliases=" + this.getMaxYamlAliases() + ")";
        }

        @Generated
        public static class ParametersBuilder {
            @Generated
            private boolean maxYamlAliases$set;
            @Generated
            private int maxYamlAliases$value;

            @Generated
            ParametersBuilder() {
            }

            @Generated
            public ParametersBuilder maxYamlAliases(int maxYamlAliases) {
                this.maxYamlAliases$value = maxYamlAliases;
                this.maxYamlAliases$set = true;
                return this;
            }

            @Generated
            public Parameters build() {
                int maxYamlAliases$value = this.maxYamlAliases$value;
                if (!this.maxYamlAliases$set) {
                    maxYamlAliases$value = Parameters.$default$maxYamlAliases();
                }
                return new Parameters(maxYamlAliases$value);
            }

            @Generated
            public String toString() {
                return "ObjectMapYamlDeserializer.Parameters.ParametersBuilder(maxYamlAliases$value=" + this.maxYamlAliases$value + ")";
            }
        }
    }

    private static class ObjectMapConstructor
    extends Constructor {
        ObjectMapConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
        }

        protected List<Object> createDefaultList(int initSize) {
            return new ObjectArray();
        }

        protected Map<Object, Object> createDefaultMap(int initSize) {
            return new LinkedHashMap<Object, Object>(initSize);
        }
    }
}

