/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context;

import com.mx.path.core.common.collection.SingleValueMap;
import java.util.function.Consumer;
import lombok.Generated;

public class RequestContext {
    private static final ThreadLocal<RequestContext> THREAD_LOCAL = new ThreadLocal();
    private String clientGuid;
    private String clientId;
    private String feature;
    private String originatingIP;
    private String path;
    private String sessionTraceId;
    private String deviceTraceId;
    private String userGuid;
    @Deprecated
    private String userId;
    private SingleValueMap<String, Object> headers;
    private SingleValueMap<String, Object> params;

    public static void clear() {
        THREAD_LOCAL.remove();
    }

    public static RequestContext current() {
        return THREAD_LOCAL.get();
    }

    public void register() {
        THREAD_LOCAL.set(this);
    }

    public static void withSelfClearing(String clientId, Consumer<RequestContext> function) {
        boolean selfClearContext = false;
        if (RequestContext.current() == null) {
            ((RequestContext)((RequestContextBuilder)RequestContext.builder().clientId(clientId)).build()).register();
            selfClearContext = true;
        }
        try {
            function.accept(RequestContext.current());
        }
        finally {
            if (selfClearContext) {
                RequestContext.clear();
            }
        }
    }

    @Generated
    protected RequestContext(RequestContextBuilder<?, ?> b) {
        this.clientGuid = ((RequestContextBuilder)b).clientGuid;
        this.clientId = ((RequestContextBuilder)b).clientId;
        this.feature = ((RequestContextBuilder)b).feature;
        this.originatingIP = ((RequestContextBuilder)b).originatingIP;
        this.path = ((RequestContextBuilder)b).path;
        this.sessionTraceId = ((RequestContextBuilder)b).sessionTraceId;
        this.deviceTraceId = ((RequestContextBuilder)b).deviceTraceId;
        this.userGuid = ((RequestContextBuilder)b).userGuid;
        this.userId = ((RequestContextBuilder)b).userId;
        this.headers = ((RequestContextBuilder)b).headers;
        this.params = ((RequestContextBuilder)b).params;
    }

    @Generated
    public static RequestContextBuilder<?, ?> builder() {
        return new RequestContextBuilderImpl();
    }

    @Generated
    public RequestContextBuilder<?, ?> toBuilder() {
        return new RequestContextBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getClientGuid() {
        return this.clientGuid;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getFeature() {
        return this.feature;
    }

    @Generated
    public String getOriginatingIP() {
        return this.originatingIP;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getSessionTraceId() {
        return this.sessionTraceId;
    }

    @Generated
    public String getDeviceTraceId() {
        return this.deviceTraceId;
    }

    @Generated
    public String getUserGuid() {
        return this.userGuid;
    }

    @Deprecated
    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public SingleValueMap<String, Object> getHeaders() {
        return this.headers;
    }

    @Generated
    public SingleValueMap<String, Object> getParams() {
        return this.params;
    }

    @Generated
    public void setClientGuid(String clientGuid) {
        this.clientGuid = clientGuid;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setFeature(String feature) {
        this.feature = feature;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setSessionTraceId(String sessionTraceId) {
        this.sessionTraceId = sessionTraceId;
    }

    @Generated
    public void setDeviceTraceId(String deviceTraceId) {
        this.deviceTraceId = deviceTraceId;
    }

    @Generated
    public void setUserGuid(String userGuid) {
        this.userGuid = userGuid;
    }

    @Deprecated
    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setHeaders(SingleValueMap<String, Object> headers) {
        this.headers = headers;
    }

    @Generated
    public void setParams(SingleValueMap<String, Object> params) {
        this.params = params;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestContext)) {
            return false;
        }
        RequestContext other = (RequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientGuid = this.getClientGuid();
        String other$clientGuid = other.getClientGuid();
        if (this$clientGuid == null ? other$clientGuid != null : !this$clientGuid.equals(other$clientGuid)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$feature = this.getFeature();
        String other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !this$feature.equals(other$feature)) {
            return false;
        }
        String this$originatingIP = this.getOriginatingIP();
        String other$originatingIP = other.getOriginatingIP();
        if (this$originatingIP == null ? other$originatingIP != null : !this$originatingIP.equals(other$originatingIP)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$sessionTraceId = this.getSessionTraceId();
        String other$sessionTraceId = other.getSessionTraceId();
        if (this$sessionTraceId == null ? other$sessionTraceId != null : !this$sessionTraceId.equals(other$sessionTraceId)) {
            return false;
        }
        String this$deviceTraceId = this.getDeviceTraceId();
        String other$deviceTraceId = other.getDeviceTraceId();
        if (this$deviceTraceId == null ? other$deviceTraceId != null : !this$deviceTraceId.equals(other$deviceTraceId)) {
            return false;
        }
        String this$userGuid = this.getUserGuid();
        String other$userGuid = other.getUserGuid();
        if (this$userGuid == null ? other$userGuid != null : !this$userGuid.equals(other$userGuid)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        SingleValueMap<String, Object> this$headers = this.getHeaders();
        SingleValueMap<String, Object> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        SingleValueMap<String, Object> this$params = this.getParams();
        SingleValueMap<String, Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !this$params.equals(other$params));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientGuid = this.getClientGuid();
        result = result * 59 + ($clientGuid == null ? 43 : $clientGuid.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : $feature.hashCode());
        String $originatingIP = this.getOriginatingIP();
        result = result * 59 + ($originatingIP == null ? 43 : $originatingIP.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $sessionTraceId = this.getSessionTraceId();
        result = result * 59 + ($sessionTraceId == null ? 43 : $sessionTraceId.hashCode());
        String $deviceTraceId = this.getDeviceTraceId();
        result = result * 59 + ($deviceTraceId == null ? 43 : $deviceTraceId.hashCode());
        String $userGuid = this.getUserGuid();
        result = result * 59 + ($userGuid == null ? 43 : $userGuid.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        SingleValueMap<String, Object> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        SingleValueMap<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RequestContext(clientGuid=" + this.getClientGuid() + ", clientId=" + this.getClientId() + ", feature=" + this.getFeature() + ", originatingIP=" + this.getOriginatingIP() + ", path=" + this.getPath() + ", sessionTraceId=" + this.getSessionTraceId() + ", deviceTraceId=" + this.getDeviceTraceId() + ", userGuid=" + this.getUserGuid() + ", userId=" + this.getUserId() + ", headers=" + this.getHeaders() + ", params=" + this.getParams() + ")";
    }

    @Generated
    public RequestContext(String clientGuid, String clientId, String feature, String originatingIP, String path, String sessionTraceId, String deviceTraceId, String userGuid, String userId, SingleValueMap<String, Object> headers, SingleValueMap<String, Object> params) {
        this.clientGuid = clientGuid;
        this.clientId = clientId;
        this.feature = feature;
        this.originatingIP = originatingIP;
        this.path = path;
        this.sessionTraceId = sessionTraceId;
        this.deviceTraceId = deviceTraceId;
        this.userGuid = userGuid;
        this.userId = userId;
        this.headers = headers;
        this.params = params;
    }

    @Generated
    public void setOriginatingIP(String originatingIP) {
        this.originatingIP = originatingIP;
    }

    public static abstract class RequestContextBuilder<C extends RequestContext, B extends RequestContextBuilder<C, B>> {
        @Generated
        private String clientGuid;
        @Generated
        private String clientId;
        @Generated
        private String feature;
        @Generated
        private String originatingIP;
        @Generated
        private String path;
        @Generated
        private String sessionTraceId;
        @Generated
        private String deviceTraceId;
        @Generated
        private String userGuid;
        @Generated
        private String userId;
        private SingleValueMap<String, Object> headers = new SingleValueMap();
        private SingleValueMap<String, Object> params = new SingleValueMap();

        public final B parameter(String k, String v) {
            this.params.put((Object)k, (Object)v);
            return this.self();
        }

        public final B withParameters(Consumer<SingleValueMap<String, Object>> consumer) {
            consumer.accept(this.params);
            return this.self();
        }

        public final B header(String k, String v) {
            this.headers.put((Object)k, (Object)v);
            return this.self();
        }

        public final B withHeaders(Consumer<SingleValueMap<String, Object>> consumer) {
            consumer.accept(this.headers);
            return this.self();
        }

        @Generated
        protected B $fillValuesFrom(C instance) {
            RequestContextBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RequestContext instance, RequestContextBuilder<?, ?> b) {
            b.clientGuid(instance.clientGuid);
            b.clientId(instance.clientId);
            b.feature(instance.feature);
            b.originatingIP(instance.originatingIP);
            b.path(instance.path);
            b.sessionTraceId(instance.sessionTraceId);
            b.deviceTraceId(instance.deviceTraceId);
            b.userGuid(instance.userGuid);
            b.userId(instance.userId);
            b.headers((SingleValueMap<String, Object>)instance.headers);
            b.params((SingleValueMap<String, Object>)instance.params);
        }

        @Generated
        public B clientGuid(String clientGuid) {
            this.clientGuid = clientGuid;
            return this.self();
        }

        @Generated
        public B clientId(String clientId) {
            this.clientId = clientId;
            return this.self();
        }

        @Generated
        public B feature(String feature) {
            this.feature = feature;
            return this.self();
        }

        @Generated
        public B originatingIP(String originatingIP) {
            this.originatingIP = originatingIP;
            return this.self();
        }

        @Generated
        public B path(String path) {
            this.path = path;
            return this.self();
        }

        @Generated
        public B sessionTraceId(String sessionTraceId) {
            this.sessionTraceId = sessionTraceId;
            return this.self();
        }

        @Generated
        public B deviceTraceId(String deviceTraceId) {
            this.deviceTraceId = deviceTraceId;
            return this.self();
        }

        @Generated
        public B userGuid(String userGuid) {
            this.userGuid = userGuid;
            return this.self();
        }

        @Deprecated
        @Generated
        public B userId(String userId) {
            this.userId = userId;
            return this.self();
        }

        @Generated
        public B headers(SingleValueMap<String, Object> headers) {
            this.headers = headers;
            return this.self();
        }

        @Generated
        public B params(SingleValueMap<String, Object> params) {
            this.params = params;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RequestContext.RequestContextBuilder(clientGuid=" + this.clientGuid + ", clientId=" + this.clientId + ", feature=" + this.feature + ", originatingIP=" + this.originatingIP + ", path=" + this.path + ", sessionTraceId=" + this.sessionTraceId + ", deviceTraceId=" + this.deviceTraceId + ", userGuid=" + this.userGuid + ", userId=" + this.userId + ", headers=" + this.headers + ", params=" + this.params + ")";
        }
    }

    @Generated
    private static final class RequestContextBuilderImpl
    extends RequestContextBuilder<RequestContext, RequestContextBuilderImpl> {
        @Generated
        private RequestContextBuilderImpl() {
        }

        @Override
        @Generated
        protected RequestContextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RequestContext build() {
            return new RequestContext(this);
        }
    }
}

