/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.security.EncryptionService;
import com.mx.path.core.common.serialization.LocalDateDeserializer;
import com.mx.path.core.common.serialization.LocalDateTimeDeserializer;
import com.mx.path.core.common.session.SessionInfo;
import com.mx.path.core.context.EncryptionServiceSupplier;
import com.mx.path.core.context.GatewayContextException;
import com.mx.path.core.context.ScopeKeyGenerator;
import com.mx.path.core.context.SessionEventListener;
import com.mx.path.core.context.SessionRepositorySupplier;
import com.mx.path.core.context.store.SessionRepository;
import com.mx.path.core.context.util.XMLGregorianCalendarConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.xml.datatype.XMLGregorianCalendar;

public class Session
implements SessionInfo {
    private static Supplier<SessionRepository> repositorySupplier = new SessionRepositorySupplier();
    private static Supplier<EncryptionService> encryptionServiceSupplier = new EncryptionServiceSupplier();
    private static final int DEFAULT_TIMEOUT_SECONDS = 1800;
    private static Gson gson = new GsonBuilder().registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarConverter.Deserializer()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarConverter.Serializer()).registerTypeAdapter(LocalDateTime.class, (Object)LocalDateTimeDeserializer.builder().build()).registerTypeAdapter(LocalDate.class, (Object)LocalDateDeserializer.builder().build()).create();
    private static ThreadLocal<List<SessionEventListener>> eventListenersThreadLocal = new ThreadLocal();
    private static ThreadLocal<Session> sessionThreadLocal = new ThreadLocal();
    private String clientId;
    private Long expiresAt;
    private String deviceId;
    private String deviceMake;
    private String deviceModel;
    private String deviceOperatingSystem;
    private String deviceOperatingSystemVersion;
    private Integer deviceHeight;
    private Double deviceLatitude;
    private Double deviceLongitude;
    private Integer deviceWidth;
    private String email;
    private String id;
    private String firstName;
    private String lastName;
    private SessionState sessionState = SessionState.UNAUTHENTICATED;
    private LocalDateTime startedAt;
    private String userId;

    public static SessionRepository getRepository() {
        if (Objects.isNull(repositorySupplier)) {
            throw new GatewayContextException("No repositorySupplier registered for Session");
        }
        return repositorySupplier.get();
    }

    public static EncryptionService getEncryptionService() {
        if (Objects.isNull(encryptionServiceSupplier)) {
            throw new GatewayContextException("No encryptionServiceSupplier registered for Session");
        }
        return encryptionServiceSupplier.get();
    }

    public static void clearSession() {
        sessionThreadLocal.remove();
        eventListenersThreadLocal.remove();
    }

    public static void createSession() {
        UUID uuid = UUID.randomUUID();
        String sessionId = uuid.toString();
        Session session = Session.start(sessionId);
        sessionThreadLocal.set(session);
    }

    public static Session current() {
        return sessionThreadLocal.get();
    }

    public static void deleteCurrent() {
        if (Session.current() != null) {
            Session.current().delete();
        }
    }

    public static List<SessionEventListener> getSessionEventListeners() {
        List<SessionEventListener> listeners = eventListenersThreadLocal.get();
        if (listeners == null) {
            listeners = new ArrayList<SessionEventListener>();
            eventListenersThreadLocal.set(listeners);
        }
        return listeners;
    }

    public static void registerSessionEventListener(SessionEventListener listener) {
        Session.getSessionEventListeners().add(listener);
    }

    public static void loadSession(String sessionId) {
        if (sessionId == null) {
            return;
        }
        Session session = Session.getRepository().load(sessionId);
        if (session == null) {
            return;
        }
        sessionThreadLocal.set(session);
    }

    public static void setCurrent(Session session) {
        sessionThreadLocal.set(session);
    }

    public static Supplier<SessionRepository> getRepositorySupplier() {
        return repositorySupplier;
    }

    public static Supplier<EncryptionService> getEncryptionServiceSupplier() {
        return encryptionServiceSupplier;
    }

    public static void setRepositorySupplier(Supplier<SessionRepository> supplier) {
        repositorySupplier = supplier;
    }

    public static void setEncryptionServiceSupplier(Supplier<EncryptionService> supplier) {
        encryptionServiceSupplier = supplier;
    }

    protected static Session start(String sessionId) {
        Session newSession = new Session();
        newSession.id = sessionId;
        newSession.startedAt = LocalDateTime.now(ZoneId.of("UTC"));
        newSession.expiresAt = newSession.startedAt.plusSeconds(1800L).toEpochSecond(ZoneOffset.UTC);
        return newSession;
    }

    protected static Session start(String sessionId, String userId) {
        Session newSession = Session.start(sessionId);
        newSession.userId = userId;
        return newSession;
    }

    @Deprecated
    public final String getClientId() {
        return this.clientId;
    }

    public final void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public final String getDeviceId() {
        return this.deviceId;
    }

    public final void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public final Integer getDeviceHeight() {
        return this.deviceHeight;
    }

    public final void setDeviceHeight(Integer deviceHeight) {
        this.deviceHeight = deviceHeight;
    }

    public final Double getDeviceLatitude() {
        return this.deviceLatitude;
    }

    public final void setDeviceLatitude(Double deviceLatitude) {
        this.deviceLatitude = deviceLatitude;
    }

    public final Double getDeviceLongitude() {
        return this.deviceLongitude;
    }

    public final void setDeviceLongitude(Double deviceLongitude) {
        this.deviceLongitude = deviceLongitude;
    }

    public final String getDeviceMake() {
        return this.deviceMake;
    }

    public final void setDeviceMake(String deviceMake) {
        this.deviceMake = deviceMake;
    }

    public final String getDeviceModel() {
        return this.deviceModel;
    }

    public final void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public final String getDeviceOperatingSystem() {
        return this.deviceOperatingSystem;
    }

    public final void setDeviceOperatingSystem(String deviceOperatingSystem) {
        this.deviceOperatingSystem = deviceOperatingSystem;
    }

    public final String getDeviceOperatingSystemVersion() {
        return this.deviceOperatingSystemVersion;
    }

    public final void setDeviceOperatingSystemVersion(String deviceOperatingSystemVersion) {
        this.deviceOperatingSystemVersion = deviceOperatingSystemVersion;
    }

    public final Integer getDeviceWidth() {
        return this.deviceWidth;
    }

    public final void setDeviceWidth(Integer deviceWidth) {
        this.deviceWidth = deviceWidth;
    }

    public final String getEmail() {
        return this.decryptValue(this.email);
    }

    public final void setEmail(String email) {
        this.email = this.encryptValue(email);
    }

    public final void setId(String newId) {
        this.id = newId;
    }

    public final String getId() {
        return this.id;
    }

    public final String getSessionId() {
        return this.getId();
    }

    public final void setExpiresAt(Long newExpiresAt) {
        this.expiresAt = newExpiresAt;
    }

    public final Long getExpiresAt() {
        return this.expiresAt;
    }

    public final String getFirstName() {
        return this.decryptValue(this.firstName);
    }

    public final void setFirstName(String firstName) {
        this.firstName = this.encryptValue(firstName);
    }

    public final String getLastName() {
        return this.decryptValue(this.lastName);
    }

    public final void setLastName(String lastName) {
        this.lastName = this.encryptValue(lastName);
    }

    public final SessionState getSessionState() {
        return this.sessionState;
    }

    public final void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public final void setStartedAt(LocalDateTime newStartedAt) {
        this.startedAt = newStartedAt;
    }

    public final LocalDateTime getStartedAt() {
        return this.startedAt;
    }

    public final void setUserId(String newUserId) {
        this.userId = newUserId;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final void delete() {
        Session.getRepository().delete(this);
        Session.clearSession();
    }

    @Deprecated
    public final void delete(String key) {
        Session.getRepository().deleteValue(this, key);
    }

    public final void delete(ScopeKeyGenerator scope, String key) {
        Session.getRepository().deleteValue(this, this.buildScopeKey(scope, key));
    }

    @Deprecated
    public final String get(String key) {
        String value = Session.getRepository().getValue(this, key);
        return this.decryptValue(value);
    }

    public final String get(ScopeKeyGenerator scope, String key) {
        String value = Session.getRepository().getValue(this, this.buildScopeKey(scope, key));
        return this.decryptValue(value);
    }

    public final long getExpiresIn() {
        long now = LocalDateTime.now(ZoneId.of("UTC")).toEpochSecond(ZoneOffset.UTC);
        return this.expiresAt - now;
    }

    public final <T> T getObj(ScopeKeyGenerator scope, String key, Class<T> klass) {
        return (T)gson.fromJson(this.get(scope, key), klass);
    }

    @Deprecated
    public final void put(String key, String value) {
        Session.getRepository().saveValue(this, key, value);
    }

    public final void put(ScopeKeyGenerator scope, String key, String value) {
        Session.getRepository().saveValue(this, this.buildScopeKey(scope, key), value);
    }

    public final void putObj(ScopeKeyGenerator scope, String key, Object obj) {
        this.put(scope, key, gson.toJson(obj));
    }

    public final void sput(ScopeKeyGenerator scope, String key, String value) {
        this.put(scope, key, this.encryptValue(value));
    }

    public final void sputObj(ScopeKeyGenerator scope, String key, Object value) {
        this.sput(scope, key, gson.toJson(value));
    }

    public final void save() {
        this.notifyBeforeSave();
        Session.getRepository().save(this);
    }

    private String buildScopeKey(ScopeKeyGenerator scope, String key) {
        return scope.generate() + "." + key;
    }

    private String decryptValue(String value) {
        if (Objects.isNull(value) || Strings.isBlank((String)value)) {
            return value;
        }
        EncryptionService encryptionService = Session.getEncryptionService();
        if (Objects.nonNull(encryptionService) && encryptionService.isEncrypted(value)) {
            try {
                return encryptionService.decrypt(value);
            }
            catch (Exception e) {
                throw new GatewayContextException("Unable to decrypt. Assuming key got rotated prematurely. Killing session.", e);
            }
        }
        return value;
    }

    private String encryptValue(String value) {
        EncryptionService encryptionService = Session.getEncryptionService();
        if (Objects.isNull(encryptionService)) {
            throw new GatewayContextException("Encryption service not configured");
        }
        return encryptionService.encrypt(value);
    }

    private void notifyBeforeSave() {
        Session.getSessionEventListeners().stream().forEach(listener -> listener.beforeSave(this));
    }

    public static enum SessionState {
        UNAUTHENTICATED,
        AUTHENTICATED,
        CHALLENGED,
        PINTOPASSWORD;

    }
}

