/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context.facility;

import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.event.EventBus;
import com.mx.path.core.common.exception.ExceptionReporter;
import com.mx.path.core.common.messaging.MessageBroker;
import com.mx.path.core.common.process.FaultTolerantExecutor;
import com.mx.path.core.common.security.EncryptionService;
import com.mx.path.core.common.store.Store;
import com.mx.path.core.context.GatewayContextException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class Facilities {
    private static final Map<String, Store> CACHE_STORES = new ConcurrentHashMap<String, Store>();
    private static final Map<String, EncryptionService> ENCRYPTION_SERVICES = new ConcurrentHashMap<String, EncryptionService>();
    private static final Map<String, ExceptionReporter> EXCEPTION_REPORTERS = new ConcurrentHashMap<String, ExceptionReporter>();
    private static final Map<String, EventBus> EVENT_BUSES = new ConcurrentHashMap<String, EventBus>();
    private static final Map<String, FaultTolerantExecutor> FAULT_TOLERANT_EXECUTORS = new ConcurrentHashMap<String, FaultTolerantExecutor>();
    private static final Map<String, MessageBroker> MESSAGE_BROKERS = new ConcurrentHashMap<String, MessageBroker>();
    private static final Map<String, Store> SECRET_STORES = new ConcurrentHashMap<String, Store>();
    private static final Map<String, Store> SESSION_STORES = new ConcurrentHashMap<String, Store>();

    public static Store getCacheStore(String clientId) {
        return CACHE_STORES.get(clientId);
    }

    public static EncryptionService getEncryptionService(String clientId) {
        return ENCRYPTION_SERVICES.get(clientId);
    }

    public static EventBus getEventBus(String clientId) {
        return EVENT_BUSES.get(clientId);
    }

    public static ExceptionReporter getExceptionReporter(String clientId) {
        return EXCEPTION_REPORTERS.get(clientId);
    }

    public static FaultTolerantExecutor getFaultTolerantExecutor(String clientId) {
        return FAULT_TOLERANT_EXECUTORS.get(clientId);
    }

    public static MessageBroker getMessageBroker(String clientId) {
        return MESSAGE_BROKERS.get(clientId);
    }

    public static Store getSecretStore(String clientId) {
        return SECRET_STORES.get(clientId);
    }

    public static Store getSessionStore(String clientId) {
        return SESSION_STORES.get(clientId);
    }

    public static void addEventBus(String clientId, EventBus eventBus) {
        if (EVENT_BUSES.containsKey(clientId)) {
            throw new GatewayContextException("Attempting to overwrite GatewayEventBus for client: " + clientId + ". Only one can be registered. Use #getEventBus().");
        }
        EVENT_BUSES.put(clientId, eventBus);
    }

    public static void setCacheStore(@NonNull String clientId, @NonNull Store store) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        CACHE_STORES.put(clientId, store);
    }

    public static void setEncryptionService(@NonNull String clientId, @NonNull EncryptionService encryptionService) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (encryptionService == null) {
            throw new NullPointerException("encryptionService is marked non-null but is null");
        }
        ENCRYPTION_SERVICES.put(clientId, encryptionService);
    }

    public static void setExceptionReporter(@NonNull String clientId, @NonNull ExceptionReporter exceptionReporter) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (exceptionReporter == null) {
            throw new NullPointerException("exceptionReporter is marked non-null but is null");
        }
        EXCEPTION_REPORTERS.put(clientId, exceptionReporter);
    }

    public static void setFaultTolerantExecutor(@NonNull String clientId, @NonNull FaultTolerantExecutor faultTolerantExecutor) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (faultTolerantExecutor == null) {
            throw new NullPointerException("faultTolerantExecutor is marked non-null but is null");
        }
        FAULT_TOLERANT_EXECUTORS.put(clientId, faultTolerantExecutor);
    }

    public static void setMessageBroker(@NonNull String clientId, @NonNull MessageBroker messageBroker) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (messageBroker == null) {
            throw new NullPointerException("messageBroker is marked non-null but is null");
        }
        MESSAGE_BROKERS.put(clientId, messageBroker);
    }

    public static void setSecretStore(@NonNull String clientId, @NonNull Store store) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        SECRET_STORES.put(clientId, store);
    }

    public static void setSessionStore(@NonNull String clientId, @NonNull Store store) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        SESSION_STORES.put(clientId, store);
    }

    public static void reset() {
        CACHE_STORES.clear();
        ENCRYPTION_SERVICES.clear();
        EVENT_BUSES.clear();
        FAULT_TOLERANT_EXECUTORS.clear();
        MESSAGE_BROKERS.clear();
        SECRET_STORES.clear();
        SESSION_STORES.clear();
    }

    public static void describe(String clientId, ObjectMap description) {
        Facilities.describeFacility(CACHE_STORES.get(clientId), description.createMap("cacheStore"));
        Facilities.describeFacility(ENCRYPTION_SERVICES.get(clientId), description.createMap("encryptionService"));
        Facilities.describeFacility(FAULT_TOLERANT_EXECUTORS.get(clientId), description.createMap("faultTolerantExecutor"));
        Facilities.describeFacility(MESSAGE_BROKERS.get(clientId), description.createMap("messageBroker"));
        Facilities.describeFacility(SECRET_STORES.get(clientId), description.createMap("secretStore"));
        Facilities.describeFacility(SESSION_STORES.get(clientId), description.createMap("sessionStore"));
    }

    private static void describeFacility(Object facility, ObjectMap description) {
        if (facility == null) {
            return;
        }
        try {
            description.put((Object)"class", (Object)facility.getClass().getCanonicalName());
            Method configurationGetter = facility.getClass().getMethod("getConfigurations", new Class[0]);
            description.put((Object)"configurations", (Object)((ObjectMap)configurationGetter.invoke(facility, new Object[0])));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            description.put((Object)"configurations", (Object)"no description provided");
        }
    }
}

