/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context.store;

import com.mx.path.core.common.store.Store;
import com.mx.path.core.context.store.ScopedStoreClient;
import com.mx.path.core.context.store.ScopedStoreCurrentSession;
import com.mx.path.core.context.store.ScopedStoreCurrentUser;
import com.mx.path.core.context.store.ScopedStoreGlobal;
import java.util.Objects;
import java.util.Set;

public abstract class ScopedStore
implements Store {
    private final Store store;

    public ScopedStore(Store store) {
        this.store = store;
    }

    public static Store build(Store store, String scope) {
        if (Objects.equals("global", scope)) {
            return new ScopedStoreGlobal(store);
        }
        if (Objects.equals("client", scope)) {
            return new ScopedStoreClient(store);
        }
        if (Objects.equals("user", scope)) {
            return new ScopedStoreCurrentUser(store);
        }
        return new ScopedStoreCurrentSession(store);
    }

    protected abstract String buildKey(String var1);

    public final void delete(String key) {
        this.store.delete(this.buildKey(key));
    }

    public final String get(String key) {
        return this.store.get(this.buildKey(key));
    }

    public final void put(String key, String value, long expirySeconds) {
        this.store.put(this.buildKey(key), value, expirySeconds);
    }

    public final void put(String key, String value) {
        this.store.put(this.buildKey(key), value);
    }

    public void putSet(String key, String value, long expirySeconds) {
        this.store.putSet(this.buildKey(key), value, expirySeconds);
    }

    public void putSet(String key, String value) {
        this.store.putSet(this.buildKey(key), value);
    }

    public void deleteSet(String key, String value) {
        this.store.deleteSet(this.buildKey(key), value);
    }

    public boolean inSet(String key, String value) {
        return this.store.inSet(this.buildKey(key), value);
    }

    public Set<String> getSet(String key) {
        return this.store.getSet(this.buildKey(key));
    }

    public final boolean putIfNotExist(String key, String value, long expirySeconds) {
        return this.store.putIfNotExist(this.buildKey(key), value, expirySeconds);
    }

    public final boolean putIfNotExist(String key, String value) {
        return this.store.putIfNotExist(this.buildKey(key), value);
    }
}

