/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context.store;

import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.process.Lock;
import com.mx.path.core.common.store.Store;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang.RandomStringUtils;

public class StoreLock
extends Lock {
    private static final int DEFAULT_TOKEN_LENGTH = 30;
    private static final long DEFAULT_POLL_MILLISECONDS = 50L;
    private static final int DEFAULT_MAX_LOCK_LENGTH_SECONDS = 10;
    private static final long DEFAULT_ACQUIRE_TIMEOUT_MILLISECONDS = 30L;
    private final String lockKey;
    private long acquireTimeoutMilliseconds;
    private long pollMilliseconds;
    private int maxLockLengthSeconds;
    private final Store store;
    private final String token;

    public StoreLock(Store store, String key, ObjectMap configurations) {
        this.lockKey = "lock_token:" + key;
        this.token = RandomStringUtils.randomAlphanumeric((int)configurations.getAsInteger("tokenLength", 30));
        this.pollMilliseconds = configurations.getAsLong("pollMilliseconds", 50L);
        this.maxLockLengthSeconds = configurations.getAsInteger("maxLockLengthSeconds", 10);
        this.acquireTimeoutMilliseconds = configurations.getAsLong("acquireTimeoutMilliseconds", 30L);
        this.store = store;
    }

    public final String currentLockValue() {
        return this.store.get(this.lockKey);
    }

    public final Lock.LockState acquire() {
        long start = System.currentTimeMillis();
        while (!this.acquired()) {
            if (this.acquireTimeoutMilliseconds > 0L && System.currentTimeMillis() - start >= this.acquireTimeoutMilliseconds) {
                return this.acquired() ? Lock.LockState.Acquired : Lock.LockState.Timeout;
            }
            this.request();
            try {
                Thread.sleep(this.pollMilliseconds);
            }
            catch (InterruptedException interruptedException) {}
        }
        return Lock.LockState.Acquired;
    }

    public final boolean acquired() {
        return Objects.equals(this.token, this.currentLockValue());
    }

    public final Lock.LockState acquireOr(Supplier<Boolean> waitUntil) {
        long start = System.currentTimeMillis();
        while (true) {
            if (this.acquireTimeoutMilliseconds > 0L && System.currentTimeMillis() - start >= this.acquireTimeoutMilliseconds) {
                return this.acquired() ? Lock.LockState.Acquired : Lock.LockState.Timeout;
            }
            if (waitUntil.get().booleanValue()) {
                return Lock.LockState.ConditionMet;
            }
            this.request();
            if (this.acquired()) {
                return Lock.LockState.Acquired;
            }
            Thread.sleep(this.pollMilliseconds);
        }
    }

    public final void close() {
        if (this.acquired()) {
            this.store.delete(this.lockKey);
        }
    }

    public final Lock.LockState request() {
        return this.store.putIfNotExist(this.lockKey, this.token, (long)this.maxLockLengthSeconds) ? Lock.LockState.Acquired : Lock.LockState.NotAcquired;
    }

    @Generated
    public String getLockKey() {
        return this.lockKey;
    }

    @Generated
    public long getAcquireTimeoutMilliseconds() {
        return this.acquireTimeoutMilliseconds;
    }

    @Generated
    public void setAcquireTimeoutMilliseconds(long acquireTimeoutMilliseconds) {
        this.acquireTimeoutMilliseconds = acquireTimeoutMilliseconds;
    }

    @Generated
    public long getPollMilliseconds() {
        return this.pollMilliseconds;
    }

    @Generated
    public void setPollMilliseconds(long pollMilliseconds) {
        this.pollMilliseconds = pollMilliseconds;
    }

    @Generated
    public int getMaxLockLengthSeconds() {
        return this.maxLockLengthSeconds;
    }

    @Generated
    public void setMaxLockLengthSeconds(int maxLockLengthSeconds) {
        this.maxLockLengthSeconds = maxLockLengthSeconds;
    }

    @Generated
    public String getToken() {
        return this.token;
    }
}

