/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context.tracing;

import com.mx.path.core.context.tracing.HttpHeadersCarrier;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.Map;

public class CustomTracer {
    private static Tracer tracer;

    public static void setTracer(Tracer tracer) {
        CustomTracer.tracer = tracer;
    }

    public static Tracer getTracer() {
        return tracer;
    }

    public static String getSpanId() {
        if (CustomTracer.getSpanContext() != null) {
            return CustomTracer.getSpanContext().toSpanId();
        }
        return null;
    }

    public static String getTraceId() {
        if (CustomTracer.getSpanContext() != null) {
            return CustomTracer.getSpanContext().toTraceId();
        }
        return null;
    }

    public static SpanContext getSpanContext() {
        if (tracer != null && tracer.activeSpan() != null) {
            return tracer.activeSpan().context();
        }
        return null;
    }

    public static Span startSpan(String name) {
        if (tracer != null) {
            return tracer.buildSpan(name).start();
        }
        return null;
    }

    public static Span startChildSpanFromSpanContext(String name, SpanContext spanContext) {
        Span span = tracer.buildSpan(name).asChildOf(spanContext).start();
        return span;
    }

    public static void injectSpanContextIntoHeaders(Map<String, String> headers) {
        if (CustomTracer.getSpanContext() != null) {
            tracer.inject(tracer.activeSpan().setTag((Tag)Tags.SPAN_KIND, (Object)"client").context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier(headers));
        }
    }

    public static Scope activateSpan(Span span) {
        return tracer.activateSpan(span);
    }
}

