/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.core.context.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mx.path.core.common.serialization.LocalDateTimeDeserializer;
import com.mx.path.core.common.store.Store;
import com.mx.path.core.context.Session;
import com.mx.path.core.context.store.ScopedStoreSession;
import com.mx.path.core.context.store.SessionRepository;
import java.time.LocalDateTime;

public class SessionRepositoryImpl
implements SessionRepository {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)LocalDateTimeDeserializer.builder().build()).create();
    private Store store;

    public SessionRepositoryImpl(Store store) {
        this.store = store;
    }

    @Override
    public final void delete(Session session) {
        this.store.delete(session.getId());
    }

    @Override
    public final void deleteValue(Session session, String key) {
        this.getScopedStoreSession(session).delete(key);
    }

    @Override
    public final String getValue(Session session, String key) {
        return this.getScopedStoreSession(session).get(key);
    }

    @Override
    public final Session load(String sessionId) {
        String json = this.store.get(sessionId);
        return json != null ? (Session)GSON.fromJson(json, Session.class) : null;
    }

    @Override
    public final void save(Session session) {
        String json = GSON.toJson((Object)session);
        this.store.put(session.getId(), json, session.getExpiresIn());
    }

    @Override
    public final void saveValue(Session session, String key, String value) {
        this.getScopedStoreSession(session).put(key, value, session.getExpiresIn());
    }

    @Override
    public final boolean setIfNotExist(Session session, String key, String value) {
        return this.setIfNotExist(session, key, value, session.getExpiresIn());
    }

    @Override
    public final boolean setIfNotExist(Session session, String key, String value, long expiryMilliseconds) {
        return this.getScopedStoreSession(session).putIfNotExist(key, value, expiryMilliseconds);
    }

    private Store getScopedStoreSession(Session session) {
        return new ScopedStoreSession(this.store, session);
    }
}

