/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway;

import com.google.common.collect.ImmutableList;
import com.mx.path.connect.messaging.remote.RemoteService;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.event.EventBus;
import com.mx.path.core.common.reflection.Annotations;
import com.mx.path.core.context.RequestContext;
import com.mx.path.core.context.facility.Facilities;
import com.mx.path.gateway.accessor.Accessor;
import com.mx.path.gateway.accessor.AccessorResponse;
import com.mx.path.gateway.behavior.GatewayBehavior;
import com.mx.path.gateway.behavior.StartBehavior;
import com.mx.path.gateway.configuration.AccessorDescriber;
import com.mx.path.gateway.configuration.RootGateway;
import com.mx.path.gateway.context.GatewayRequestContext;
import com.mx.path.gateway.event.AfterAccessorEvent;
import com.mx.path.gateway.event.BeforeAccessorEvent;
import com.mx.path.gateway.service.GatewayService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public abstract class Gateway<T extends Accessor> {
    private String clientId;
    private T baseAccessor;
    private Gateway parent;
    private RemoteService<?> remote;
    private List<GatewayBehavior> behaviors = Collections.emptyList();
    private List<GatewayService> services;

    public Gateway() {
    }

    public Gateway(String clientId) {
        this.clientId = clientId;
    }

    public final boolean isTopLevel() {
        return Annotations.hasAnnotation(this.getClass(), RootGateway.class);
    }

    public ImmutableList<Gateway> gateways() {
        return ImmutableList.copyOf((Collection)Arrays.stream(this.getClass().getMethods()).filter(method -> Gateway.class.isAssignableFrom(method.getReturnType())).filter(method -> method.getReturnType() != Gateway.class).map(method -> {
            try {
                return (Gateway)method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public void registerRemotes() {
        if (this.remote != null) {
            this.remote.register();
        }
        this.gateways().forEach(Gateway::registerRemotes);
    }

    public void startServices() {
        this.services.forEach(service -> {
            if (service.getGateway() == null) {
                service.setGateway(this);
            }
            service.start();
        });
        this.gateways().forEach(Gateway::startServices);
    }

    public final ObjectMap describe() {
        ObjectMap description = new ObjectMap();
        this.describe(description);
        return description;
    }

    public void describe(ObjectMap description) {
        if (this.isTopLevel()) {
            Facilities.describe((String)this.clientId, (ObjectMap)description.createMap("facilities"));
        } else {
            try {
                Method getAccessorMethod = this.getClass().getDeclaredMethod("getAccessor", new Class[0]);
                Accessor accessor = (Accessor)getAccessorMethod.invoke((Object)this, new Object[0]);
                this.describeAccessors(accessor, description.createMap("accessor"));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        description.put((Object)"services", this.services.stream().map(GatewayService::describe).collect(Collectors.toList()));
        description.put((Object)"behaviors", this.behaviors.stream().map(GatewayBehavior::describe).collect(Collectors.toList()));
        if (this.baseAccessor == null) {
            throw new RuntimeException("Base accessor not provided to gateway " + this.getClass().getTypeName());
        }
    }

    public void describeAccessors(Accessor accessorToDescribe, ObjectMap description) {
        AccessorDescriber accessorDescriber = new AccessorDescriber();
        accessorDescriber.describe(accessorToDescribe, description);
    }

    public final <T extends Gateway> T getParent() {
        return (T)this.parent;
    }

    protected final GatewayBehavior buildStack() {
        StartBehavior stack;
        GatewayBehavior previous = stack = new StartBehavior();
        for (GatewayBehavior behavior : this.behaviors) {
            previous.setNextBehavior(behavior);
            previous = behavior;
        }
        return stack;
    }

    protected final <T> AccessorResponse<T> executeBehaviorStack(Class<T> responseType, GatewayRequestContext request, GatewayBehavior terminatingBehavior) {
        return this.buildStack().execute(responseType, request, terminatingBehavior);
    }

    public final Gateway root() {
        if (this.parent != null) {
            return this.parent.root();
        }
        return this.isTopLevel() ? this : null;
    }

    public final void afterAccessor(Gateway gateway, Accessor callingAccessor, RequestContext requestContext) {
        if (requestContext.getClientId() == null) {
            return;
        }
        EventBus eventBus = Facilities.getEventBus((String)requestContext.getClientId());
        if (eventBus == null) {
            return;
        }
        eventBus.post((Object)AfterAccessorEvent.builder().currentAccessor(callingAccessor).gateway(gateway).requestContext(requestContext).build());
    }

    public final void beforeAccessor(Gateway gateway, Accessor callingAccessor, RequestContext requestContext) {
        if (requestContext.getClientId() == null) {
            return;
        }
        EventBus eventBus = Facilities.getEventBus((String)requestContext.getClientId());
        if (eventBus == null) {
            return;
        }
        eventBus.post((Object)BeforeAccessorEvent.builder().currentAccessor(callingAccessor).gateway(gateway).requestContext(requestContext).build());
    }

    @Generated
    protected Gateway(GatewayBuilder<T, ?, ?> b) {
        List<Object> services;
        List<Object> behaviors;
        this.clientId = ((GatewayBuilder)b).clientId;
        this.baseAccessor = ((GatewayBuilder)b).baseAccessor;
        this.parent = ((GatewayBuilder)b).parent;
        this.remote = ((GatewayBuilder)b).remote;
        switch (((GatewayBuilder)b).behaviors == null ? 0 : ((GatewayBuilder)b).behaviors.size()) {
            case 0: {
                behaviors = Collections.emptyList();
                break;
            }
            case 1: {
                behaviors = Collections.singletonList((GatewayBehavior)((GatewayBuilder)b).behaviors.get(0));
                break;
            }
            default: {
                behaviors = Collections.unmodifiableList(new ArrayList(((GatewayBuilder)b).behaviors));
            }
        }
        this.behaviors = behaviors;
        switch (((GatewayBuilder)b).services == null ? 0 : ((GatewayBuilder)b).services.size()) {
            case 0: {
                services = Collections.emptyList();
                break;
            }
            case 1: {
                services = Collections.singletonList((GatewayService)((GatewayBuilder)b).services.get(0));
                break;
            }
            default: {
                services = Collections.unmodifiableList(new ArrayList(((GatewayBuilder)b).services));
            }
        }
        this.services = services;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public T getBaseAccessor() {
        return this.baseAccessor;
    }

    @Generated
    public void setParent(Gateway parent) {
        this.parent = parent;
    }

    @Generated
    public RemoteService<?> getRemote() {
        return this.remote;
    }

    @Generated
    public void setRemote(RemoteService<?> remote) {
        this.remote = remote;
    }

    @Generated
    public List<GatewayBehavior> getBehaviors() {
        return this.behaviors;
    }

    @Generated
    public List<GatewayService> getServices() {
        return this.services;
    }

    @Generated
    public static abstract class GatewayBuilder<T extends Accessor, C extends Gateway<T>, B extends GatewayBuilder<T, C, B>> {
        @Generated
        private String clientId;
        @Generated
        private T baseAccessor;
        @Generated
        private Gateway parent;
        @Generated
        private RemoteService<?> remote;
        @Generated
        private ArrayList<GatewayBehavior> behaviors;
        @Generated
        private ArrayList<GatewayService> services;

        @Generated
        public B clientId(String clientId) {
            this.clientId = clientId;
            return this.self();
        }

        @Generated
        public B baseAccessor(T baseAccessor) {
            this.baseAccessor = baseAccessor;
            return this.self();
        }

        @Generated
        public B parent(Gateway parent) {
            this.parent = parent;
            return this.self();
        }

        @Generated
        public B remote(RemoteService<?> remote) {
            this.remote = remote;
            return this.self();
        }

        @Generated
        public B behavior(GatewayBehavior behavior) {
            if (this.behaviors == null) {
                this.behaviors = new ArrayList();
            }
            this.behaviors.add(behavior);
            return this.self();
        }

        @Generated
        public B behaviors(Collection<? extends GatewayBehavior> behaviors) {
            if (behaviors == null) {
                throw new NullPointerException("behaviors cannot be null");
            }
            if (this.behaviors == null) {
                this.behaviors = new ArrayList();
            }
            this.behaviors.addAll(behaviors);
            return this.self();
        }

        @Generated
        public B clearBehaviors() {
            if (this.behaviors != null) {
                this.behaviors.clear();
            }
            return this.self();
        }

        @Generated
        public B service(GatewayService service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this.self();
        }

        @Generated
        public B services(Collection<? extends GatewayService> services) {
            if (services == null) {
                throw new NullPointerException("services cannot be null");
            }
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this.self();
        }

        @Generated
        public B clearServices() {
            if (this.services != null) {
                this.services.clear();
            }
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Gateway.GatewayBuilder(clientId=" + this.clientId + ", baseAccessor=" + this.baseAccessor + ", parent=" + this.parent + ", remote=" + this.remote + ", behaviors=" + this.behaviors + ", services=" + this.services + ")";
        }
    }
}

