/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.accessor;

import com.mx.path.core.common.accessor.API;
import com.mx.path.core.common.accessor.AccessorException;
import com.mx.path.core.common.accessor.PathResponseStatus;
import com.mx.path.core.common.gateway.GatewayAPI;
import com.mx.path.gateway.accessor.AccessorConfiguration;
import com.mx.path.gateway.accessor.AccessorMethodDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class Accessor {
    private AccessorConfiguration configuration;

    @Nonnull
    public static Class<? extends Accessor> getAccessorBase(Class<? extends Accessor> klass) {
        Class<? extends Accessor> currentClass = klass;
        do {
            if (currentClass.getSuperclass() != Accessor.class) continue;
            return currentClass.asSubclass(Accessor.class);
        } while ((currentClass = currentClass.getSuperclass()).getSuperclass() != null);
        return currentClass.asSubclass(Accessor.class);
    }

    public static List<AccessorMethodDefinition> getBaseChildAccessorMethods(Class<? extends Accessor> klass) {
        Class<? extends Accessor> base = Accessor.getAccessorBase(klass);
        Method[] baseMethods = base.getDeclaredMethods();
        return Arrays.stream(baseMethods).map(method -> {
            API[] apis = (API[])method.getDeclaredAnnotationsByType(API.class);
            GatewayAPI[] functionAnnotation = (GatewayAPI[])method.getDeclaredAnnotationsByType(GatewayAPI.class);
            if (apis.length > 0 && functionAnnotation.length == 0) {
                return AccessorMethodDefinition.builder().accessorClass(base).annotation(apis[0]).method((Method)method).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Accessor(AccessorConfiguration configuration) {
        this.configuration = configuration;
    }

    public List<AccessorMethodDefinition> getChildAccessors() {
        return Accessor.getBaseChildAccessorMethods(this.getClass()).stream().map(baseAccessorMethodDefinition -> {
            try {
                Method declaredMethod = this.getClass().getMethod(baseAccessorMethodDefinition.getMethod().getName(), new Class[0]);
                API api = Arrays.stream((API[])baseAccessorMethodDefinition.getMethod().getDeclaredAnnotationsByType(API.class)).findFirst().orElse(null);
                Accessor accessor = (Accessor)declaredMethod.invoke((Object)this, new Object[0]);
                return AccessorMethodDefinition.builder().accessorClass(accessor.getClass()).annotation(api).method(declaredMethod).base((AccessorMethodDefinition)baseAccessorMethodDefinition).instance(accessor).build();
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof AccessorException && ((AccessorException)e.getTargetException()).getStatus() != PathResponseStatus.NOT_IMPLEMENTED) {
                    System.out.println("Accessor implementation for " + baseAccessorMethodDefinition.getMethod().getName() + " raised exception : " + e.getTargetException().getClass());
                    e.getTargetException().printStackTrace();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public AccessorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AccessorConfiguration configuration) {
        this.configuration = configuration;
    }
}

