/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.behavior;

import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.gateway.accessor.AccessorResponse;
import com.mx.path.gateway.context.GatewayRequestContext;
import lombok.Generated;

public abstract class GatewayBehavior {
    private ObjectMap configurations;
    private GatewayBehavior nextBehavior;

    public GatewayBehavior(ObjectMap configurations) {
        this.configurations = configurations;
    }

    public GatewayBehavior(ObjectMap configurations, GatewayBehavior nextBehavior) {
        this(configurations);
        this.nextBehavior = nextBehavior;
    }

    public <T> AccessorResponse<T> execute(Class<T> resultType, GatewayRequestContext request, GatewayBehavior terminatingBehavior) {
        return this.call(resultType, request, terminatingBehavior);
    }

    protected abstract <T> AccessorResponse<T> call(Class<T> var1, GatewayRequestContext var2, GatewayBehavior var3);

    protected <T> AccessorResponse<T> callNext(Class<T> resultType, GatewayRequestContext request, GatewayBehavior terminatingBehavior) {
        if (this.nextBehavior != null) {
            return this.nextBehavior.call(resultType, request, terminatingBehavior);
        }
        return terminatingBehavior.call(resultType, request, terminatingBehavior);
    }

    public ObjectMap describe() {
        ObjectMap description = new ObjectMap();
        description.put((Object)"class", (Object)this.getClass().getSimpleName());
        if (this.configurations != null && !this.configurations.isEmpty()) {
            description.put((Object)"configurations", (Object)this.configurations);
        }
        return description;
    }

    @Generated
    public ObjectMap getConfigurations() {
        return this.configurations;
    }

    @Generated
    public void setNextBehavior(GatewayBehavior nextBehavior) {
        this.nextBehavior = nextBehavior;
    }

    @Generated
    public GatewayBehavior getNextBehavior() {
        return this.nextBehavior;
    }
}

