/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mx.path.core.common.collection.ObjectArray;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.configuration.Configuration;
import com.mx.path.core.common.connect.AccessorConnectionSettings;
import com.mx.path.core.common.gateway.GatewayException;
import com.mx.path.core.common.serialization.ObjectMapJsonDeserializer;
import com.mx.path.gateway.accessor.Accessor;
import com.mx.path.gateway.accessor.AccessorConfiguration;
import com.mx.path.gateway.configuration.ConfigurationBinder;
import com.mx.path.gateway.configuration.ConfigurationError;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.ConnectionConstructionContext;
import com.mx.path.gateway.configuration.annotations.ClientID;
import com.mx.path.gateway.configuration.annotations.Connection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class AccessorConstructionContext<T extends Accessor> {
    private final List<Object> constructorArgs = new ArrayList<Object>();
    private final Map<String, ConnectionConstructionContext> connections = new HashMap<String, ConnectionConstructionContext>();
    private final Class<? extends T> accessorClass;
    private final AccessorConfiguration accessorConfiguration;
    private final ConfigurationState state;
    private Constructor<? extends T> constructor;

    public <V extends T> AccessorConstructionContext(Class<V> accessorClass, AccessorConfiguration configuration) {
        this.accessorConfiguration = configuration;
        this.accessorClass = accessorClass;
        this.state = ConfigurationState.getCurrent();
        ConfigurationBinder binder = new ConfigurationBinder(configuration.getClientId(), this.state);
        this.state.withLevel("accessor", () -> this.state.withLevel(accessorClass.getSimpleName(), () -> {
            this.constructor = this.findBestConstructor(accessorClass);
            Arrays.stream(this.constructor.getParameters()).forEach(param -> {
                if (AccessorConfiguration.class.isAssignableFrom(param.getType())) {
                    this.constructorArgs.add(configuration);
                    return;
                }
                if (param.isAnnotationPresent(ClientID.class)) {
                    this.constructorArgs.add(this.accessorConfiguration.getClientId());
                    return;
                }
                Configuration configurationAnnotation = param.getAnnotation(Configuration.class);
                if (configurationAnnotation != null) {
                    this.state.withLevel(param.getType().getSimpleName(), () -> this.constructorArgs.add(binder.build(param.getType(), configuration.getConfigurations())));
                    return;
                }
                Connection connectionAnnotation = param.getAnnotation(Connection.class);
                if (connectionAnnotation != null) {
                    this.state.withLevel("connections." + connectionAnnotation.value(), () -> {
                        AccessorConnectionSettings accessorConnectionSettings = this.getAccessorConfiguration().getConnections().getConnection(connectionAnnotation.value());
                        if (!connectionAnnotation.optional() && accessorConnectionSettings == null) {
                            throw new ConfigurationError("No connection configuration provided for required " + connectionAnnotation.value(), this.state);
                        }
                        ConnectionConstructionContext connectionConstructionContext = new ConnectionConstructionContext(this.accessorConfiguration.getClientId(), this.state, param.getType(), accessorConnectionSettings);
                        this.constructorArgs.add(connectionConstructionContext);
                        this.connections.put(connectionAnnotation.value(), connectionConstructionContext);
                    });
                    return;
                }
                throw new ConfigurationError("Unable to bind param " + param.getName() + " for constructor " + accessorClass.getCanonicalName(), this.state);
            });
            this.build();
        }));
    }

    public final T build() {
        try {
            return (T)((Accessor)this.getConstructor().newInstance(this.buildConstructorArgs().toArray()));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new GatewayException("Unable to construct accessor " + this.getAccessorClass().getCanonicalName(), (Throwable)e);
        }
    }

    public final void describe(ObjectMap description) {
        ObjectArray boundConfigurations;
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(ObjectMap.class, (Object)new ObjectMapJsonDeserializer());
        Gson gson = gsonBuilder.create();
        this.getAccessorConfiguration().describe(description);
        List<Object> configurationArguments = this.constructorArgs.stream().filter(arg -> !AccessorConfiguration.class.isAssignableFrom(arg.getClass()) && !AccessorConnectionSettings.class.isAssignableFrom(arg.getClass())).collect(Collectors.toList());
        if (!configurationArguments.isEmpty()) {
            boundConfigurations = description.getMap("configurations").createArray(":bindings:");
            configurationArguments.forEach(arg -> {
                if (arg.getClass() != ConnectionConstructionContext.class) {
                    ObjectMap argumentDescription = boundConfigurations.createMap();
                    argumentDescription.put((Object)"class", (Object)arg.getClass().getCanonicalName());
                    argumentDescription.put((Object)arg.getClass().getSimpleName(), gson.fromJson(gson.toJson(arg), ObjectMap.class));
                }
            });
        }
        if (!this.connections.isEmpty()) {
            boundConfigurations = description.getMap("connections").createMap(":bindings:");
            this.connections.forEach((arg_0, arg_1) -> AccessorConstructionContext.lambda$describe$7((ObjectMap)boundConfigurations, gson, arg_0, arg_1));
        }
    }

    private List<Object> buildConstructorArgs() {
        return this.constructorArgs.stream().map(arg -> {
            if (ConnectionConstructionContext.class.isAssignableFrom(arg.getClass())) {
                return ((ConnectionConstructionContext)arg).build();
            }
            return arg;
        }).collect(Collectors.toList());
    }

    private <K extends T> Constructor<K> findBestConstructor(Class<K> klass) {
        List<Constructor<Object>> constructors = Arrays.asList(klass.getDeclaredConstructors());
        if ((constructors = constructors.stream().filter(c -> Arrays.stream(c.getParameters()).anyMatch(param -> param.getType() == AccessorConfiguration.class)).collect(Collectors.toList())).isEmpty()) {
            throw new ConfigurationError("Accessor Constructor must accept AccessorConfiguration: " + klass.getCanonicalName(), this.state);
        }
        if ((constructors = constructors.stream().filter(c -> Arrays.stream(c.getParameters()).allMatch(param -> param.getType() == AccessorConfiguration.class || param.isAnnotationPresent(Configuration.class) || param.isAnnotationPresent(Connection.class) || param.isAnnotationPresent(ClientID.class))).collect(Collectors.toList())).size() > 1) {
            throw new ConfigurationError("Too many valid constructors for " + klass.getCanonicalName(), this.state);
        }
        if (constructors.isEmpty()) {
            throw new ConfigurationError("No valid constructors for " + klass.getCanonicalName(), this.state);
        }
        return constructors.get(0);
    }

    @Generated
    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    @Generated
    public Map<String, ConnectionConstructionContext> getConnections() {
        return this.connections;
    }

    @Generated
    public Class<? extends T> getAccessorClass() {
        return this.accessorClass;
    }

    @Generated
    public AccessorConfiguration getAccessorConfiguration() {
        return this.accessorConfiguration;
    }

    @Generated
    public ConfigurationState getState() {
        return this.state;
    }

    @Generated
    public Constructor<? extends T> getConstructor() {
        return this.constructor;
    }

    private static /* synthetic */ void lambda$describe$7(ObjectMap boundConfigurations, Gson gson, String name, ConnectionConstructionContext connectionConstructionContext) {
        AccessorConnectionSettings connection = connectionConstructionContext.build();
        ObjectMap connectionDescription = boundConfigurations.createMap(name);
        ObjectMap map = (ObjectMap)gson.fromJson(gson.toJson((Object)connection), ObjectMap.class);
        connectionDescription.put((Object)"class", (Object)connection.getClass().getCanonicalName());
        connectionDescription.put((Object)connection.getClass().getSimpleName(), (Object)map);
    }
}

