/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.mx.path.core.common.accessor.API;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.reflection.Annotations;
import com.mx.path.core.common.reflection.Fields;
import com.mx.path.gateway.accessor.Accessor;
import com.mx.path.gateway.accessor.AccessorConfiguration;
import com.mx.path.gateway.accessor.AccessorMethodDefinition;
import com.mx.path.gateway.accessor.AccessorResponse;
import com.mx.path.gateway.configuration.AccessorConstructionContext;
import com.mx.path.gateway.configuration.AccessorProxy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;

public class AccessorDescriber {
    public final ObjectMap describe(@Nonnull Accessor accessor) {
        ObjectMap result = new ObjectMap();
        this.describe(accessor, result);
        return result;
    }

    public final void describe(@Nonnull Accessor accessor, @Nonnull ObjectMap result) {
        Class<Object> klass;
        Class<?> proxyClass = null;
        if (AccessorProxy.class.isAssignableFrom(accessor.getClass())) {
            klass = ((AccessorProxy)((Object)accessor)).getAccessorClass();
            proxyClass = accessor.getClass();
        } else {
            klass = accessor.getClass();
        }
        Class<? extends Accessor> parentClass = Accessor.getAccessorBase(klass);
        this.describeClass(result, klass, parentClass, proxyClass);
        this.describeOperations(result, klass, parentClass);
        this.describeConfiguration(result, accessor);
    }

    public final ObjectMap describeDeep(@Nonnull Accessor accessor) {
        ObjectMap description = new ObjectMap();
        this.describeDeep(accessor, description);
        return description;
    }

    public final void describeDeep(@Nonnull Accessor accessor, @Nonnull ObjectMap description) {
        AccessorDescriber describer = new AccessorDescriber();
        describer.describe(accessor, description);
        List<AccessorMethodDefinition> childAccessors = Accessor.getBaseChildAccessorMethods(accessor.getClass());
        if (!childAccessors.isEmpty()) {
            description.createMap("accessors");
        }
        childAccessors.forEach(childAccessorDef -> {
            Accessor childAccessor = null;
            try {
                childAccessor = (Accessor)childAccessorDef.getMethod().invoke((Object)accessor, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (childAccessor != null) {
                this.describeDeep(childAccessor, description.getMap("accessors").createMap(childAccessorDef.getMethod().getName()));
            }
        });
    }

    private void describeConfiguration(ObjectMap result, Accessor accessor) {
        Method getConfiguration;
        if (AccessorProxy.class.isAssignableFrom(accessor.getClass())) {
            Field field;
            try {
                field = accessor.getClass().getSuperclass().getDeclaredField("accessorConstructionContext");
            }
            catch (NoSuchFieldException e) {
                result.put((Object)"configurations", (Object)"unable to load construction context");
                return;
            }
            AccessorConstructionContext constructionContext = (AccessorConstructionContext)Fields.getFieldValue((Field)field, (Object)accessor);
            constructionContext.describe(result);
            return;
        }
        Class<?> klass = accessor.getClass();
        try {
            getConfiguration = klass.getMethod("getConfiguration", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        if (getConfiguration.getReturnType() == AccessorConfiguration.class) {
            AccessorConfiguration configuration;
            try {
                configuration = (AccessorConfiguration)getConfiguration.invoke((Object)accessor, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return;
            }
            if (configuration != null) {
                configuration.describe(result);
            }
        }
    }

    private void describeOperations(ObjectMap result, Class<?> klass, Class<?> parentClass) {
        ObjectMap operationsNode = new ObjectMap();
        result.put((Object)"operations", (Object)operationsNode);
        Map<String, MethodDefinition> parentClassMethods = this.getAnnotatedMethods(parentClass);
        Map<String, MethodDefinition> classMethods = this.findDeclaredMethods(klass, parentClassMethods.keySet());
        parentClassMethods.forEach((name, parentDefinition) -> {
            MethodDefinition definition = (MethodDefinition)classMethods.get(name);
            if (definition != null && definition.method.getDeclaringClass() == klass) {
                ObjectMap apiDescription = operationsNode.createMap(name);
                Description description = this.merge(((MethodDefinition)parentDefinition).annotation, definition.annotation);
                description.describe(apiDescription);
            }
        });
    }

    private void describeClass(ObjectMap result, Class<?> klass, Class<?> parentClass, Class<?> proxyClass) {
        result.put((Object)"class", (Object)klass.getCanonicalName());
        result.put((Object)"parentClass", (Object)parentClass.getCanonicalName());
        if (proxyClass != null) {
            result.put((Object)"proxyClass", (Object)proxyClass.getCanonicalName());
        }
        API parentAnnotation = parentClass.getAnnotation(API.class);
        API annotation = klass.getAnnotation(API.class);
        if (parentAnnotation == null) {
            if (annotation == null) {
                throw new RuntimeException("Accessor " + klass.getCanonicalName() + " or parent class" + parentClass.getCanonicalName() + " must be annotated with API");
            }
            parentAnnotation = annotation;
        }
        Description classDescription = this.merge(parentAnnotation, annotation);
        classDescription.describe(result);
    }

    private Map<String, MethodDefinition> findDeclaredMethods(Class<?> accessorClass, Set<String> strings) {
        LinkedHashMap<String, MethodDefinition> result = new LinkedHashMap<String, MethodDefinition>();
        Arrays.stream(accessorClass.getDeclaredMethods()).filter(method -> strings.contains(method.getName())).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getReturnType() == AccessorResponse.class).map(method -> MethodDefinition.builder().name(method.getName()).annotation(method.getAnnotation(API.class)).method((Method)method).build()).collect(Collectors.toList()).forEach(definition -> result.put(((MethodDefinition)definition).name, (MethodDefinition)definition));
        return result;
    }

    private Map<String, MethodDefinition> getAnnotatedMethods(Class<?> accessorClass) {
        LinkedHashMap<String, MethodDefinition> result = new LinkedHashMap<String, MethodDefinition>();
        Annotations.methodsWithAnnotation(API.class, accessorClass).stream().filter(method -> method.getReturnType() == AccessorResponse.class).filter(method -> Modifier.isPublic(method.getModifiers())).map(method -> {
            API annotation = method.getAnnotation(API.class);
            return MethodDefinition.builder().name(method.getName()).annotation(annotation).method((Method)method).build();
        }).filter(definition -> Objects.nonNull(((MethodDefinition)definition).annotation)).forEach(definition -> result.put(((MethodDefinition)definition).name, (MethodDefinition)definition));
        return result;
    }

    private Description merge(API parent, API child) {
        Description result = new Description();
        if (child == null) {
            result.setDescription(parent.description());
            result.setNotes(parent.notes());
            result.setSpecification(parent.specificationUrl());
        } else {
            result.setDescription(this.stringWithDefault(child.description(), parent.description()));
            result.setNotes(this.stringWithDefault(child.notes(), parent.notes()));
            result.setSpecification(this.stringWithDefault(child.specificationUrl(), parent.specificationUrl()));
        }
        return result;
    }

    private String stringWithDefault(String str, String def) {
        if (Strings.isNotBlank((String)str)) {
            return str;
        }
        return def;
    }

    static class Description {
        private String description;
        private String notes;
        private String specification;

        public final void describe(ObjectMap desc) {
            if (Strings.isNotBlank((String)this.description)) {
                desc.put((Object)"description", (Object)this.description);
            }
            if (Strings.isNotBlank((String)this.notes)) {
                desc.put((Object)"notes", (Object)this.notes);
            }
            if (Strings.isNotBlank((String)this.specification)) {
                desc.put((Object)"specification", (Object)this.specification);
            }
        }

        @Generated
        public Description() {
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getNotes() {
            return this.notes;
        }

        @Generated
        public String getSpecification() {
            return this.specification;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setNotes(String notes) {
            this.notes = notes;
        }

        @Generated
        public void setSpecification(String specification) {
            this.specification = specification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Description)) {
                return false;
            }
            Description other = (Description)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$notes = this.getNotes();
            String other$notes = other.getNotes();
            if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
                return false;
            }
            String this$specification = this.getSpecification();
            String other$specification = other.getSpecification();
            return !(this$specification == null ? other$specification != null : !this$specification.equals(other$specification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Description;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $notes = this.getNotes();
            result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
            String $specification = this.getSpecification();
            result = result * 59 + ($specification == null ? 43 : $specification.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccessorDescriber.Description(description=" + this.getDescription() + ", notes=" + this.getNotes() + ", specification=" + this.getSpecification() + ")";
        }
    }

    static class MethodDefinition {
        private String name;
        private Method method;
        private API annotation;

        @Generated
        MethodDefinition(String name, Method method, API annotation) {
            this.name = name;
            this.method = method;
            this.annotation = annotation;
        }

        @Generated
        public static MethodDefinitionBuilder builder() {
            return new MethodDefinitionBuilder();
        }

        @Generated
        public static class MethodDefinitionBuilder {
            @Generated
            private String name;
            @Generated
            private Method method;
            @Generated
            private API annotation;

            @Generated
            MethodDefinitionBuilder() {
            }

            @Generated
            public MethodDefinitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public MethodDefinitionBuilder method(Method method) {
                this.method = method;
                return this;
            }

            @Generated
            public MethodDefinitionBuilder annotation(API annotation) {
                this.annotation = annotation;
                return this;
            }

            @Generated
            public MethodDefinition build() {
                return new MethodDefinition(this.name, this.method, this.annotation);
            }

            @Generated
            public String toString() {
                return "AccessorDescriber.MethodDefinition.MethodDefinitionBuilder(name=" + this.name + ", method=" + this.method + ", annotation=" + this.annotation + ")";
            }
        }
    }
}

