/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.mx.path.core.common.accessor.RootAccessor;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.connect.AccessorConnectionSettings;
import com.mx.path.core.common.connect.RequestFilter;
import com.mx.path.core.common.gateway.GatewayException;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.reflection.Annotations;
import com.mx.path.core.common.reflection.Fields;
import com.mx.path.core.common.session.ServiceScope;
import com.mx.path.core.utility.reflection.ClassHelper;
import com.mx.path.gateway.GatewayBuilderHelper;
import com.mx.path.gateway.accessor.Accessor;
import com.mx.path.gateway.accessor.AccessorConfiguration;
import com.mx.path.gateway.accessor.AccessorConnections;
import com.mx.path.gateway.configuration.AccessorProxy;
import com.mx.path.gateway.configuration.AccessorProxyMap;
import com.mx.path.gateway.configuration.ConfigurationError;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.annotations.AccessorScope;
import com.mx.path.gateway.configuration.annotations.ChildAccessor;
import com.mx.path.gateway.configuration.annotations.ChildAccessors;
import com.mx.path.gateway.configuration.annotations.MaxScope;
import com.mx.path.gateway.connect.filter.CallbacksFilter;
import com.mx.path.gateway.connect.filter.ErrorHandlerFilter;
import com.mx.path.gateway.connect.filter.FaultTolerantRequestFilter;
import com.mx.path.gateway.connect.filter.RequestFinishedFilter;
import com.mx.path.gateway.connect.filter.TracingFilter;
import com.mx.path.gateway.connect.filter.UpstreamRequestEventFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessorStackConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessorStackConfigurator.class);
    private Accessor rootAccessor;
    private final ConfigurationState state;

    public AccessorStackConfigurator(ConfigurationState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Accessor buildAccessor(String name, ObjectMap map, String clientId, Object builder, Accessor parent) {
        ObjectMap node = map.getMap("accessor");
        this.state.pushLevel(name);
        try {
            Accessor accessor;
            if (node == null) {
                GatewayBuilderHelper.setRootAccessor(builder, this.rootAccessor);
                if (parent == null) {
                    Accessor accessor2 = null;
                    return accessor2;
                }
                accessor = this.buildFromParent(name, clientId, parent);
            } else {
                accessor = this.buildFromNode(clientId, node);
            }
            if (accessor == null) {
                Accessor accessor3 = null;
                return accessor3;
            }
            if (Annotations.hasAnnotation(accessor.getClass(), RootAccessor.class)) {
                this.rootAccessor = accessor;
                GatewayBuilderHelper.setRootAccessor(builder, accessor);
            } else {
                GatewayBuilderHelper.setRootAccessor(builder, this.rootAccessor);
                if (parent != null) {
                    Field accessorField = this.getMatchingAccessorField(accessor.getClass(), parent);
                    Fields.setFieldValue((Field)accessorField, (Object)parent, (Object)accessor);
                }
            }
            Accessor accessor4 = accessor;
            return accessor4;
        }
        finally {
            this.state.popLevel();
        }
    }

    public final Accessor buildFromNode(String clientId, ObjectMap node) {
        AccessorConfiguration.AccessorConfigurationBuilder configurationBuilder = AccessorConfiguration.builder().clientId(clientId);
        if (node.getMap("configurations") != null) {
            configurationBuilder.configurations(node.getMap("configurations"));
        }
        if (node.getMap("connections") != null) {
            this.buildConnections(node.getMap("connections"), configurationBuilder);
        }
        Class accessorType = new ClassHelper().getClass((String)node.getAs(String.class, "class"));
        this.validateServiceScope(accessorType);
        AccessorScope accessorScope = this.determineAccessorScope(node, accessorType);
        Class<?> proxyType = AccessorProxyMap.get(accessorScope.getName(), Accessor.getAccessorBase(accessorType));
        return (Accessor)new ClassHelper().buildInstance(Accessor.class, proxyType, new Object[]{configurationBuilder.build(), accessorType});
    }

    public final Accessor buildFromParent(String name, String clientId, Accessor parent) {
        AccessorConfiguration.AccessorConfigurationBuilder configuration = AccessorConfiguration.builder().clientId(clientId);
        AtomicReference<Class> accessorType = new AtomicReference<Class>();
        AtomicReference<String> accessorScope = new AtomicReference<String>();
        try {
            Class<? extends Accessor> parentClass = ((AccessorProxy)((Object)parent)).getAccessorClass();
            Class<? extends Accessor> parentBaseClass = Accessor.getAccessorBase(parentClass);
            Class<? extends Accessor> baseAccessorClass = Accessor.getAccessorBase(parentBaseClass.getDeclaredField(name).getType());
            accessorScope.set(((AccessorProxy)((Object)parent)).getScope());
            List<ChildAccessor> allChildAccessors = this.getChildAccessors(parentClass);
            accessorType.set(allChildAccessors.stream().map(ChildAccessor::value).filter(childClass -> Accessor.getAccessorBase(childClass) == baseAccessorClass).findFirst().orElse(null));
            if (accessorType.get() == null) {
                return null;
            }
            configuration.configurations(parent.getConfiguration().getConfigurations());
            configuration.connections(parent.getConfiguration().getConnections());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Mis-configured accessor: " + name, e);
        }
        Class<?> proxyType = AccessorProxyMap.get((String)accessorScope.get(), Accessor.getAccessorBase((Class)accessorType.get()));
        Accessor accessor = (Accessor)new ClassHelper().buildInstance(Accessor.class, proxyType, new Object[]{configuration.build(), accessorType.get()});
        return accessor;
    }

    private void buildConnections(ObjectMap map, AccessorConfiguration.AccessorConfigurationBuilder builder) {
        AccessorConnections connections = new AccessorConnections();
        map.keySet().forEach(connectionName -> {
            AccessorConnectionSettings.AccessorConnectionSettingsBuilder connection = AccessorConnectionSettings.builder();
            connection.baseUrl(map.getMap(connectionName).getAsString("baseUrl"));
            connection.certificateAlias(map.getMap(connectionName).getAsString("certificateAlias"));
            connection.keystorePath(map.getMap(connectionName).getAsString("keystorePath"));
            String passwordString = map.getMap(connectionName).getAsString("keystorePassword");
            if (passwordString != null) {
                connection.keystorePassword(passwordString.toCharArray());
            }
            connection.skipHostNameVerify(Boolean.parseBoolean(String.valueOf(map.getMap(connectionName).get((Object)"skipHostNameVerify"))));
            connection.baseRequestFilter((RequestFilter)new TracingFilter());
            connection.baseRequestFilter((RequestFilter)new UpstreamRequestEventFilter());
            connection.baseRequestFilter((RequestFilter)new ErrorHandlerFilter());
            connection.baseRequestFilter((RequestFilter)new CallbacksFilter());
            connection.baseRequestFilter((RequestFilter)new RequestFinishedFilter());
            connection.baseRequestFilter((RequestFilter)new FaultTolerantRequestFilter());
            AccessorConnectionSettings conn = connection.build();
            this.validateConnection(conn);
            connections.addConnection((String)connectionName, conn);
            if (map.getMap(connectionName).getMap("configurations") != null) {
                map.getMap(connectionName).getMap("configurations").forEach((arg_0, arg_1) -> ((AccessorConnectionSettings.AccessorConnectionSettingsBuilder)connection).configuration(arg_0, arg_1));
            }
        });
        builder.connections(connections);
    }

    private AccessorScope determineAccessorScope(ObjectMap node, Class<? extends Accessor> accessorType) {
        return this.state.withField("scope", () -> {
            AccessorScope calculatedScope;
            AccessorScope configurationScope = this.getConfigurationAccessorScope(node);
            MaxScope maxScope = accessorType.getAnnotation(MaxScope.class);
            if (maxScope == null) {
                LOGGER.warn("Class missing MaxScope annotation. This will be required in the future. (" + accessorType.getCanonicalName() + ")");
            }
            if (configurationScope != null) {
                calculatedScope = configurationScope;
            } else if (maxScope != null) {
                calculatedScope = maxScope.value();
            } else {
                throw new ConfigurationError("No scope provided for accessor. (" + accessorType.getCanonicalName() + ")", this.state);
            }
            if (maxScope != null && calculatedScope.getValue() > maxScope.value().getValue()) {
                throw new ConfigurationError("Configured scope (" + calculatedScope.getName() + ") is higher that specified MaxScope (" + maxScope.value().getName() + ")", this.state);
            }
            return calculatedScope;
        });
    }

    private List<ChildAccessor> getChildAccessors(Class<? extends Accessor> parentClass) {
        ChildAccessors childAccessors = parentClass.getAnnotation(ChildAccessors.class);
        ChildAccessor childAccessor = parentClass.getAnnotation(ChildAccessor.class);
        ArrayList<ChildAccessor> allChildAccessors = new ArrayList<ChildAccessor>();
        if (childAccessors != null) {
            Collections.addAll(allChildAccessors, childAccessors.value());
        }
        if (childAccessor != null) {
            allChildAccessors.add(childAccessor);
        }
        return allChildAccessors;
    }

    private AccessorScope getConfigurationAccessorScope(ObjectMap node) {
        String configurationScopeValue = (String)node.getAs(String.class, "scope");
        AccessorScope configurationScope = AccessorScope.resolve(configurationScopeValue);
        if (Strings.isNotBlank((String)configurationScopeValue) && configurationScope == null) {
            throw new ConfigurationError("Invalid scope (" + configurationScopeValue + ")", this.state);
        }
        return configurationScope;
    }

    private Field getMatchingAccessorField(Class<? extends Accessor> accessorType, Accessor parent) {
        Field accessorField = Arrays.stream(Accessor.getAccessorBase(parent.getClass()).getDeclaredFields()).filter(field -> field.getType() == Accessor.getAccessorBase(accessorType)).findFirst().orElse(null);
        if (accessorField == null) {
            throw new RuntimeException("Mis-configured accessor stack. Chain is broken");
        }
        return accessorField;
    }

    private void validateConnection(AccessorConnectionSettings conn) {
        String keystorePassword = "";
        if (conn.getKeystorePassword() != null) {
            keystorePassword = new String(conn.getKeystorePassword());
        }
        if (Strings.isNotBlank((String)conn.getCertificateAlias()) || Strings.isNotBlank((String)conn.getKeystorePath()) || Strings.isNotBlank((String)keystorePassword)) {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("certificateAlias", conn.getCertificateAlias());
            values.put("keystorePath", conn.getKeystorePath());
            values.put("keystorePassword", keystorePassword);
            List missingKeys = values.entrySet().stream().filter(e -> Strings.isBlank((String)((String)e.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
            if (!missingKeys.isEmpty()) {
                throw new GatewayException("Invalid connection details. Missing " + String.join((CharSequence)", ", missingKeys));
            }
        }
    }

    private void validateServiceScope(Class<? extends Accessor> accessor) {
        if (!accessor.isAnnotationPresent(ServiceScope.class)) {
            LOGGER.warn("Class missing ServiceScope annotation. This will be required in the future. (" + accessor.getCanonicalName() + ")");
        }
    }

    @Generated
    public void setRootAccessor(Accessor rootAccessor) {
        this.rootAccessor = rootAccessor;
    }
}

