/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.mx.path.core.common.collection.ObjectArray;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.gateway.behavior.GatewayBehavior;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.GatewayObjectConfigurator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;

public class BehaviorStackConfigurator {
    private final ConfigurationState state;
    private final GatewayObjectConfigurator gatewayObjectConfigurator;
    private ObjectArray rootBehaviors;

    public BehaviorStackConfigurator(ConfigurationState state) {
        this.state = state;
        this.gatewayObjectConfigurator = new GatewayObjectConfigurator(state);
    }

    public final List<GatewayBehavior> buildFromNode(ObjectMap map, String clientId) {
        return this.state.withLevel("behaviors", () -> {
            ArrayList<GatewayBehavior> behaviors = new ArrayList<GatewayBehavior>();
            ObjectArray behaviorsMap = new ObjectArray();
            if (this.getRootBehaviors() != null) {
                behaviorsMap.addAll((Collection)this.getRootBehaviors());
            }
            if (map.getArray("behaviors") != null) {
                behaviorsMap.addAll((Collection)map.getArray("behaviors"));
            }
            this.addBehaviors(behaviors, behaviorsMap, clientId);
            return behaviors;
        });
    }

    private void addBehaviors(List<GatewayBehavior> behaviors, ObjectArray behaviorsMap, String clientId) {
        if (behaviorsMap == null) {
            return;
        }
        behaviorsMap.forEach(node -> behaviors.add(this.gatewayObjectConfigurator.buildFromNode((ObjectMap)node, clientId, GatewayBehavior.class)));
    }

    @Generated
    public ObjectArray getRootBehaviors() {
        return this.rootBehaviors;
    }

    @Generated
    public void setRootBehaviors(ObjectArray rootBehaviors) {
        this.rootBehaviors = rootBehaviors;
    }
}

