/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.google.common.base.Supplier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.mx.path.core.common.collection.ObjectArray;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.configuration.ConfigurationField;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.reflection.Annotations;
import com.mx.path.core.common.reflection.Constructors;
import com.mx.path.core.common.reflection.Fields;
import com.mx.path.core.common.serialization.ConfigurationTypeAdapter;
import com.mx.path.core.utility.reflection.ClassHelper;
import com.mx.path.gateway.configuration.Configurable;
import com.mx.path.gateway.configuration.ConfigurationError;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.GatewayObjectConfigurator;
import com.mx.path.gateway.configuration.annotations.ClientID;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayObjectConfigurator.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)new ConfigurationTypeAdapter.Factory()).create();
    private final ConfigurationState state;
    private final String clientId;

    public ConfigurationBinder(String clientId, ConfigurationState state) {
        this.clientId = clientId;
        this.state = state;
    }

    public <T> T build(Class<T> klass, ObjectMap configurationMap) {
        Object configuration = Constructors.instantiateWithNoArgumentConstructor(klass);
        this.configure(configuration, configurationMap);
        return (T)configuration;
    }

    public final void configure(Object configuration, ObjectMap configurationMap) {
        this.populateFields(configuration, configurationMap);
        if (Configurable.class.isAssignableFrom(configuration.getClass())) {
            ((Configurable)configuration).initialize();
            ((Configurable)configuration).validate(this.state);
        }
        try {
            LOGGER.debug("Configuration binding: " + configuration.getClass().getName() + " -> " + GSON.toJson(configuration));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to serialize configuration: " + configuration.getClass().getName(), (Throwable)e);
        }
    }

    private List<Object> buildArray(ObjectArray configurationValue, Annotations.AnnotatedField<ConfigurationField> annotatedField, boolean inArray) {
        ArrayList array = new ArrayList();
        annotatedField.setElementType(this.resolveArrayElementClass(annotatedField));
        if (annotatedField.getElementType() == null) {
            throw new ConfigurationError("Must provide elementType if configuration element is a list", this.state);
        }
        return (List)this.buildInArray(inArray, annotatedField.getField().getName(), () -> {
            int objectIndex = 0;
            for (Object item : configurationValue) {
                this.state.pushLevel(String.valueOf(objectIndex++));
                try {
                    array.add(this.buildValue(item, annotatedField, true));
                }
                finally {
                    this.state.popLevel();
                }
            }
            return array;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T buildInArray(boolean inArray, String level, Supplier<T> supplier) {
        if (!inArray) {
            this.state.pushLevel(level);
        }
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (!inArray) {
                this.state.popLevel();
            }
        }
    }

    private Object buildObject(ObjectMap configurationMap, Annotations.AnnotatedField<ConfigurationField> annotatedField, boolean inArray) {
        return this.buildInArray(inArray, annotatedField.getField().getName(), () -> {
            Class<?> klass;
            Class<Object> clazz = klass = annotatedField.getElementType() != null ? annotatedField.getElementType() : ((ConfigurationField)annotatedField.getAnnotation()).elementType();
            if (klass == Void.class) {
                klass = annotatedField.getField().getType();
            }
            return this.build(klass, configurationMap);
        });
    }

    private Object buildValue(Object configurationValue, Annotations.AnnotatedField<ConfigurationField> annotatedField) {
        return this.buildValue(configurationValue, annotatedField, false);
    }

    private Object buildValue(Object configurationValue, Annotations.AnnotatedField<ConfigurationField> annotatedField, boolean inArray) {
        if (configurationValue instanceof ObjectArray) {
            return this.buildArray((ObjectArray)configurationValue, annotatedField, inArray);
        }
        if (configurationValue instanceof ObjectMap) {
            return this.buildObject((ObjectMap)configurationValue, annotatedField, inArray);
        }
        return configurationValue;
    }

    private void populateFields(Object obj, ObjectMap configurationMap) {
        Map<String, Annotations.AnnotatedField<ConfigurationField>> configurationFieldMap = this.prepareConfigurationObjectFields(obj);
        configurationMap.forEach((fieldName, fieldValue) -> {
            Annotations.AnnotatedField configurationAnnotatedField = (Annotations.AnnotatedField)configurationFieldMap.get(fieldName);
            this.state.withField((String)fieldName, () -> {
                if (configurationAnnotatedField == null) {
                    throw new ConfigurationError("Unknown field", this.state);
                }
                Field field = configurationAnnotatedField.getField();
                Object value = field.getType() == HashMap.class ? fieldValue : this.buildValue(fieldValue, (Annotations.AnnotatedField<ConfigurationField>)configurationAnnotatedField);
                if (value != null) {
                    Fields.setFieldValue((Field)field, (Object)obj, (Object)value);
                }
            });
        });
        this.validate(obj);
        List clientIdFields = Annotations.fieldsWithAnnotation(ClientID.class, obj.getClass());
        clientIdFields.forEach(annotatedField -> {
            String fieldName = annotatedField.getField().getName();
            Field field = annotatedField.getField();
            this.state.withField(fieldName, () -> Fields.setFieldValue((Field)field, (Object)obj, (Object)this.clientId));
        });
    }

    private Map<String, Annotations.AnnotatedField<ConfigurationField>> prepareConfigurationObjectFields(Object obj) {
        List annotatedFields = Annotations.fieldsWithAnnotations(obj.getClass());
        return annotatedFields.stream().map(field -> field.asAnnotatedField(ConfigurationField.class)).collect(Collectors.toMap(field -> {
            if (field.getAnnotation() != null && Strings.isNotBlank((String)((ConfigurationField)field.getAnnotation()).value())) {
                return ((ConfigurationField)field.getAnnotation()).value();
            }
            return field.getField().getName();
        }, field -> field));
    }

    private Class<?> resolveArrayElementClass(Annotations.AnnotatedField<ConfigurationField> annotatedField) {
        if (annotatedField.getAnnotation() != null && ((ConfigurationField)annotatedField.getAnnotation()).elementType() != Void.class) {
            return ((ConfigurationField)annotatedField.getAnnotation()).elementType();
        }
        List klasses = new ClassHelper().resolveParameterizedFieldTypes(annotatedField.getField());
        if (klasses.size() == 1) {
            return (Class)klasses.get(0);
        }
        return null;
    }

    private void validate(Object obj) {
        List annotatedFields = Annotations.fieldsWithAnnotation(ConfigurationField.class, obj.getClass());
        annotatedFields.forEach(annotatedField -> {
            Object value = Fields.getFieldValue((Field)annotatedField.getField(), (Object)obj);
            String field = Strings.isBlank((String)((ConfigurationField)annotatedField.getAnnotation()).value()) ? annotatedField.getField().getName() : ((ConfigurationField)annotatedField.getAnnotation()).value();
            this.state.withField(field, () -> this.validateField((Annotations.AnnotatedField<ConfigurationField>)annotatedField, value));
        });
    }

    private void validateField(Annotations.AnnotatedField<ConfigurationField> annotatedField, Object value) {
        if (annotatedField.getAnnotation() == null) {
            return;
        }
        if (((ConfigurationField)annotatedField.getAnnotation()).required()) {
            if (value == null) {
                throw new ConfigurationError("Value required", this.state);
            }
            if (value instanceof String && Strings.isBlank((String)((String)value))) {
                throw new ConfigurationError("Value required", this.state);
            }
        }
    }
}

