/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.mx.path.core.common.lang.Strings;
import com.mx.path.gateway.configuration.ConfigurationError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Stack;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationState {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationState.class);
    private static ConfigurationState current = new ConfigurationState();
    private String field;
    private final Stack<String> state = new Stack();

    @SuppressFBWarnings(value={"MS_EXPOSE_REP"})
    public static ConfigurationState getCurrent() {
        return current;
    }

    static void resetCurrent() {
        current = new ConfigurationState();
    }

    private ConfigurationState() {
    }

    public String currentState() {
        return String.join((CharSequence)".", this.state);
    }

    public void field(String currentField) {
        this.field = currentField;
        if (Strings.isNotBlank((String)this.field)) {
            LOGGER.debug("Configuring: {}#{}", (Object)this.currentState(), (Object)this.field);
        }
    }

    public String field() {
        return this.field;
    }

    public String popLevel() {
        return this.state.pop();
    }

    public void pushLevel(String nextLevel) {
        this.state.push(nextLevel);
        LOGGER.debug("Configuration: {}", (Object)this.currentState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withField(String currentField, Runnable runnable) {
        this.field(currentField);
        try {
            try {
                runnable.run();
            }
            catch (ConfigurationError e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationError("A configuration error occurred", this, (Throwable)e);
            }
        }
        finally {
            this.field(null);
        }
    }

    public <T> T withField(String currentField, Supplier<T> supplier) {
        this.field(currentField);
        try {
            T t = supplier.get();
            return t;
        }
        catch (ConfigurationError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationError("A configuration error occurred", this, (Throwable)e);
        }
        finally {
            this.field(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withLevel(String nextLevel, Runnable runnable) {
        this.pushLevel(nextLevel);
        try {
            try {
                runnable.run();
            }
            catch (ConfigurationError e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationError("A configuration error occurred", this, (Throwable)e);
            }
        }
        finally {
            this.popLevel();
        }
    }

    public <T> T withLevel(String nextLevel, Supplier<T> supplier) {
        this.pushLevel(nextLevel);
        try {
            T t = supplier.get();
            return t;
        }
        catch (ConfigurationError e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationError("A configuration error occurred", this, (Throwable)e);
        }
        finally {
            this.popLevel();
        }
    }
}

