/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mx.path.connect.messaging.remote.RemoteService;
import com.mx.path.core.common.collection.ObjectArray;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.event.EventBus;
import com.mx.path.core.common.exception.ExceptionReporter;
import com.mx.path.core.common.gateway.GatewayException;
import com.mx.path.core.common.lang.Strings;
import com.mx.path.core.common.messaging.MessageBroker;
import com.mx.path.core.common.process.FaultTolerantExecutor;
import com.mx.path.core.common.security.EncryptionService;
import com.mx.path.core.common.serialization.ObjectMapJsonDeserializer;
import com.mx.path.core.common.serialization.ObjectMapYamlDeserializer;
import com.mx.path.core.common.store.Store;
import com.mx.path.core.context.facility.Facilities;
import com.mx.path.core.utility.reflection.ClassHelper;
import com.mx.path.gateway.Gateway;
import com.mx.path.gateway.GatewayBuilderHelper;
import com.mx.path.gateway.accessor.Accessor;
import com.mx.path.gateway.behavior.GatewayBehavior;
import com.mx.path.gateway.configuration.AccessorStackConfigurator;
import com.mx.path.gateway.configuration.BehaviorStackConfigurator;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.ConfiguratorObserver;
import com.mx.path.gateway.configuration.GatewayObjectConfigurator;
import com.mx.path.gateway.event.GatewayEventBus;
import com.mx.path.gateway.service.GatewayService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;

public abstract class Configurator<T extends Gateway<?>> {
    private static final int MAX_YAML_ALIASES = 100;
    private final Stack<Accessor> accessorStack = new Stack();
    private final ConfigurationState state = ConfigurationState.getCurrent();
    private final AccessorStackConfigurator accessorConfigurator = new AccessorStackConfigurator(this.state);
    private final BehaviorStackConfigurator behaviorStackConfigurator = new BehaviorStackConfigurator(this.state);
    private final GatewayObjectConfigurator gatewayObjectConfigurator = new GatewayObjectConfigurator(this.state);
    private final Class<T> rootGatewayClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private ConfiguratorObserver<T> observer = new ConfiguratorObserver(this);

    public final T buildGateway(ObjectMap map, String clientId) {
        this.behaviorStackConfigurator.setRootBehaviors(map.getArray("rootBehaviors"));
        this.populateFacilities(clientId, map);
        Object gateway = this.buildGateway("root", map, clientId, GatewayBuilderHelper.getBuilder(this.rootGatewayClass));
        this.getObserver().notifyClientGatewayInitialized(clientId, gateway);
        return (T)gateway;
    }

    public final Map<String, T> buildFromJson(String json) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(ObjectMap.class, (Object)new ObjectMapJsonDeserializer());
        Gson gson = gsonBuilder.create();
        json = StringSubstitutor.createInterpolator().replace(json);
        ObjectMap map = (ObjectMap)gson.fromJson(json, ObjectMap.class);
        return this.buildGateways(map);
    }

    public final Map<String, T> buildFromYaml(String document) {
        if (Strings.isBlank((String)document)) {
            return new LinkedHashMap();
        }
        document = StringSubstitutor.createInterpolator().replace(document);
        ObjectMapYamlDeserializer yamlSerializer = new ObjectMapYamlDeserializer(ObjectMapYamlDeserializer.Parameters.builder().maxYamlAliases(100).build());
        Object root = yamlSerializer.fromYaml(document);
        if (!(root instanceof ObjectMap)) {
            throw new RuntimeException("buildFromYaml requires an object root.");
        }
        ObjectMap map = (ObjectMap)root;
        if (map != null && map.containsKey((Object)"definitions")) {
            map.remove((Object)"definitions");
        }
        return this.buildGateways(map);
    }

    private void buildBehaviors(ObjectMap map, Object builder, String clientId) {
        List<GatewayBehavior> behaviors = this.behaviorStackConfigurator.buildFromNode(map, clientId);
        behaviors.forEach(behavior -> GatewayBuilderHelper.addBehavior(builder, behavior));
    }

    private Map<String, T> buildGateways(ObjectMap map) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        if (map != null) {
            for (String clientName : map.keySet()) {
                result.put(clientName, this.buildGateway(map.getMap(clientName), clientName));
            }
        }
        this.getObserver().notifyGatewaysInitialized(result);
        return result;
    }

    private <G extends Gateway<?>> G buildGateway(String name, ObjectMap map, String clientId, Object builder) {
        GatewayBuilderHelper.setClientId(builder, clientId);
        this.buildBehaviors(map, builder, clientId);
        this.buildServices(map, builder, clientId);
        Accessor parent = null;
        if (!this.accessorStack.isEmpty()) {
            parent = this.accessorStack.peek();
        }
        this.accessorStack.push(this.accessorConfigurator.buildAccessor(name, map, clientId, builder, parent));
        this.buildGateways(map, clientId, builder);
        this.accessorStack.pop();
        Gateway gateway = GatewayBuilderHelper.build(builder, Gateway.class);
        if (map.getMap("remotes") != null) {
            this.buildRemote(map.getMap("remotes"), gateway, clientId);
        }
        this.getObserver().notifyGatewayInitialized(gateway);
        return (G)gateway;
    }

    private void buildRemote(ObjectMap configurations, Gateway gateway, String clientId) {
        try {
            String remoteGatewayClassName = gateway.getClass().getPackage().getName().replace("api", "remote") + ".Remote" + gateway.getClass().getSimpleName();
            Class remoteGatewayClass = new ClassHelper().getClass(remoteGatewayClassName);
            Constructor constructor = remoteGatewayClass.getConstructor(String.class, gateway.getClass(), ObjectMap.class);
            RemoteService remote = (RemoteService)constructor.newInstance(clientId, gateway, configurations);
            gateway.setRemote(remote);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new GatewayException("Unable to create remote gateway " + gateway.getClass().getSimpleName(), (Throwable)e);
        }
    }

    private void buildGateways(ObjectMap map, String clientId, Object builder) {
        ObjectMap gatewaysNode = map.getMap("gateways");
        if (gatewaysNode == null) {
            return;
        }
        Arrays.stream(builder.getClass().getMethods()).filter(m -> {
            if (m.getParameterCount() == 1) {
                return Gateway.class.isAssignableFrom(m.getParameters()[0].getType());
            }
            return false;
        }).forEach(m -> {
            if (gatewaysNode.containsKey((Object)m.getName())) {
                try {
                    Object gatewayBuilder = m.getParameters()[0].getType().getMethod("builder", new Class[0]).invoke(m.getParameters()[0].getType(), new Object[0]);
                    Object gateway = this.buildGateway(m.getName(), gatewaysNode.getMap(m.getName()), clientId, gatewayBuilder);
                    m.invoke(builder, gateway);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new GatewayException("Unable to add gateway API to gateway " + m.getName(), (Throwable)e);
                }
            }
        });
    }

    private void buildServices(ObjectMap map, Object builder, String clientId) {
        ObjectArray services = map.getArray("services");
        if (services == null) {
            return;
        }
        this.state.withLevel("services", () -> services.forEach(node -> GatewayBuilderHelper.addService(builder, this.gatewayObjectConfigurator.buildFromNode((ObjectMap)node, clientId, GatewayService.class))));
    }

    private void populateFacilities(String clientId, ObjectMap map) {
        ObjectMap node = map.getMap("facilities");
        if (node == null) {
            return;
        }
        this.state.withLevel("facilities", () -> node.keySet().forEach(key -> {
            switch (key) {
                case "cacheStore": {
                    Facilities.setCacheStore((String)clientId, (Store)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, Store.class));
                    break;
                }
                case "encryptionService": {
                    Facilities.setEncryptionService((String)clientId, (EncryptionService)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, EncryptionService.class));
                    break;
                }
                case "eventBus": {
                    Facilities.addEventBus((String)clientId, (EventBus)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, EventBus.class));
                    break;
                }
                case "exceptionReporter": {
                    Facilities.setExceptionReporter((String)clientId, (ExceptionReporter)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, ExceptionReporter.class));
                    break;
                }
                case "faultTolerantExecutor": {
                    Facilities.setFaultTolerantExecutor((String)clientId, (FaultTolerantExecutor)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, FaultTolerantExecutor.class));
                    break;
                }
                case "messageBroker": {
                    Facilities.setMessageBroker((String)clientId, (MessageBroker)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, MessageBroker.class));
                    break;
                }
                case "sessionStore": {
                    Facilities.setSessionStore((String)clientId, (Store)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, Store.class));
                    break;
                }
                case "secretStore": {
                    Facilities.setSecretStore((String)clientId, (Store)this.gatewayObjectConfigurator.buildFromNode(node.getMap(key), clientId, Store.class));
                    break;
                }
                default: {
                    throw new GatewayException("Invalid facility: " + key);
                }
            }
        }));
        this.ensureDefaultFacilities(clientId);
        this.getObserver().notifyClientFacilitiesInitialized(clientId);
    }

    private void ensureDefaultFacilities(String clientId) {
        if (Facilities.getEventBus((String)clientId) == null) {
            Facilities.addEventBus((String)clientId, (EventBus)new GatewayEventBus(new ObjectMap()));
        }
    }

    @Generated
    public Class<T> getRootGatewayClass() {
        return this.rootGatewayClass;
    }

    @Generated
    public ConfiguratorObserver<T> getObserver() {
        return this.observer;
    }

    @Generated
    void setObserver(ConfiguratorObserver<T> observer) {
        this.observer = observer;
    }
}

