/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mx.path.core.common.lang.TriConsumer;
import com.mx.path.gateway.Gateway;
import com.mx.path.gateway.configuration.Configurator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;

public class ConfiguratorObserver<G extends Gateway<?>> {
    private final List<BiConsumer<Configurator<G>, String>> clientFacilitiesInitializedBlocks = new ArrayList<BiConsumer<Configurator<G>, String>>();
    private final List<TriConsumer<Configurator<G>, String, G>> clientGatewayInitializedBlocks = new ArrayList<TriConsumer<Configurator<G>, String, G>>();
    private final List<BiConsumer<Configurator<G>, Gateway<?>>> gatewayInitializedBlocks = new ArrayList();
    private final List<BiConsumer<Configurator<G>, Map<String, G>>> gatewaysInitializedBlocks = new ArrayList<BiConsumer<Configurator<G>, Map<String, G>>>();
    private final Configurator<G> configurator;
    private final EventBus eventBus;
    private final Map<String, String> properties = new HashMap<String, String>();

    public ConfiguratorObserver(Configurator<G> configurator) {
        this.configurator = configurator;
        this.eventBus = new EventBus("configuratorObserver");
        this.eventBus.register((Object)this);
    }

    @Subscribe
    final void clientFacilitiesInitializedSubscriber(ClientFacilitiesInitializedEvent<G> event) {
        this.clientFacilitiesInitializedBlocks.forEach(consumer -> consumer.accept(event.configurator, event.clientId));
    }

    @Subscribe
    final void clientGatewayInitializedSubscriber(ClientGatewayInitializedEvent<G> event) {
        this.clientGatewayInitializedBlocks.forEach(consumer -> consumer.accept((Object)event.configurator, (Object)event.clientId, (Object)event.gateway));
    }

    @Subscribe
    final void gatewayInitializedSubscriber(GatewayInitializedEvent<G> event) {
        this.gatewayInitializedBlocks.forEach(consumer -> consumer.accept(event.configurator, event.gateway));
    }

    @Subscribe
    final void gatewaysInitializedSubscriber(GatewaysInitializedEvent<G> event) {
        this.gatewaysInitializedBlocks.forEach(consumer -> consumer.accept(event.configurator, event.gateways));
    }

    final void notifyClientFacilitiesInitialized(String clientId) {
        this.eventBus.post(new ClientFacilitiesInitializedEvent<G>(this.configurator, clientId));
    }

    final void notifyClientGatewayInitialized(String clientId, G gateway) {
        this.eventBus.post(new ClientGatewayInitializedEvent<G>(this.configurator, clientId, gateway));
    }

    final void notifyGatewayInitialized(Gateway<?> gateway) {
        this.eventBus.post(new GatewayInitializedEvent<G>(this.configurator, gateway));
    }

    final void notifyGatewaysInitialized(Map<String, G> gateways) {
        this.eventBus.post(new GatewaysInitializedEvent<G>(this.configurator, gateways));
    }

    public final void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public final void registerClientFacilitiesInitialized(BiConsumer<Configurator<G>, String> consumer) {
        this.clientFacilitiesInitializedBlocks.add(consumer);
    }

    public final void registerClientGatewayInitialized(TriConsumer<Configurator<G>, String, G> consumer) {
        this.clientGatewayInitializedBlocks.add(consumer);
    }

    public final void registerGatewayInitialized(BiConsumer<Configurator<G>, Gateway<?>> consumer) {
        this.gatewayInitializedBlocks.add(consumer);
    }

    public final void registerGatewaysInitialized(BiConsumer<Configurator<G>, Map<String, G>> consumer) {
        this.gatewaysInitializedBlocks.add(consumer);
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class ClientFacilitiesInitializedEvent<T extends Gateway<?>> {
        private final Configurator<T> configurator;
        private final String clientId;

        public ClientFacilitiesInitializedEvent(Configurator<T> configurator, String clientId) {
            this.configurator = configurator;
            this.clientId = clientId;
        }

        @Generated
        public Configurator<T> getConfigurator() {
            return this.configurator;
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }
    }

    public static class ClientGatewayInitializedEvent<T extends Gateway<?>> {
        private final Configurator<T> configurator;
        private final String clientId;
        private final T gateway;

        public ClientGatewayInitializedEvent(Configurator<T> configurator, String clientId, T gateway) {
            this.configurator = configurator;
            this.clientId = clientId;
            this.gateway = gateway;
        }

        @Generated
        public Configurator<T> getConfigurator() {
            return this.configurator;
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public T getGateway() {
            return this.gateway;
        }
    }

    public static class GatewayInitializedEvent<T extends Gateway<?>> {
        private final Configurator<T> configurator;
        private final Gateway<?> gateway;

        public GatewayInitializedEvent(Configurator<T> configurator, Gateway<?> gateway) {
            this.configurator = configurator;
            this.gateway = gateway;
        }

        @Generated
        public Configurator<T> getConfigurator() {
            return this.configurator;
        }

        @Generated
        public Gateway<?> getGateway() {
            return this.gateway;
        }
    }

    public static class GatewaysInitializedEvent<T extends Gateway<?>> {
        private final Configurator<T> configurator;
        private final Map<String, T> gateways;

        public GatewaysInitializedEvent(Configurator<T> configurator, Map<String, T> gateways) {
            this.configurator = configurator;
            this.gateways = gateways;
        }

        @Generated
        public Configurator<T> getConfigurator() {
            return this.configurator;
        }

        @Generated
        public Map<String, T> getGateways() {
            return this.gateways;
        }
    }
}

