/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.mx.path.core.common.configuration.Configuration;
import com.mx.path.core.common.connect.AccessorConnectionSettings;
import com.mx.path.core.common.gateway.GatewayException;
import com.mx.path.core.common.reflection.Constructors;
import com.mx.path.core.common.reflection.Fields;
import com.mx.path.gateway.configuration.ConfigurationBinder;
import com.mx.path.gateway.configuration.ConfigurationError;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.annotations.ClientID;
import com.mx.path.gateway.configuration.annotations.Connection;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class ConnectionConstructionContext {
    private final AccessorConnectionSettings accessorConnectionSettings;
    private final String clientId;
    private final Class<? extends AccessorConnectionSettings> connectionClass;
    private final Constructor<? extends AccessorConnectionSettings> connectionConstructor;
    private final List<Object> constructorArgs;
    private final ConfigurationState state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionConstructionContext(String clientId, ConfigurationState state, Class<?> connectionClass, AccessorConnectionSettings accessorConnectionSettings) {
        this.clientId = clientId;
        this.state = state;
        if (!AccessorConnectionSettings.class.isAssignableFrom(connectionClass)) {
            throw new ConfigurationError("Connection does not implement AccessorConnectionSettings: " + connectionClass.getCanonicalName(), state);
        }
        this.connectionClass = connectionClass;
        this.accessorConnectionSettings = accessorConnectionSettings;
        this.connectionConstructor = this.findBestConstructor(this.connectionClass);
        ConfigurationBinder configurationBinder = new ConfigurationBinder(clientId, state);
        state.pushLevel(connectionClass.getSimpleName());
        try {
            this.constructorArgs = Arrays.stream(this.connectionConstructor.getParameters()).map(parameter -> {
                state.pushLevel(parameter.getType().getSimpleName());
                try {
                    if (parameter.isAnnotationPresent(ClientID.class)) {
                        String string = clientId;
                        return string;
                    }
                    if (accessorConnectionSettings != null) {
                        Object obj = configurationBinder.build(parameter.getType(), accessorConnectionSettings.getConfigurations());
                        return obj;
                    }
                    Object var5_7 = null;
                    return var5_7;
                }
                finally {
                    state.popLevel();
                }
            }).collect(Collectors.toList());
        }
        finally {
            state.popLevel();
        }
    }

    public final AccessorConnectionSettings build() {
        try {
            if (this.accessorConnectionSettings != null) {
                AccessorConnectionSettings newAccessorConnectionSettings = this.getConnectionConstructor().newInstance(this.getConstructorArgs().toArray());
                Arrays.stream(AccessorConnectionSettings.class.getDeclaredFields()).forEach(field -> this.state.withField(field.getName(), () -> Fields.setFieldValue((Field)field, (Object)newAccessorConnectionSettings, (Object)Fields.getFieldValue((Field)field, (Object)this.accessorConnectionSettings))));
                return newAccessorConnectionSettings;
            }
            return null;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new GatewayException("Unable to construct connection " + this.getConnectionClass().getCanonicalName(), (Throwable)e);
        }
    }

    private <T extends AccessorConnectionSettings> Constructor<T> findBestConstructor(Class<T> klass) {
        List<Constructor<T>> constructors = this.getConstructors(klass);
        if ((constructors = constructors.stream().filter(c -> Arrays.stream(c.getParameters()).allMatch(param -> param.getAnnotation(Configuration.class) != null || param.getAnnotation(Connection.class) != null || param.getAnnotation(ClientID.class) != null)).collect(Collectors.toList())).size() == 1) {
            return constructors.get(0);
        }
        if (constructors.size() > 1) {
            throw new ConfigurationError("Too many valid constructors for " + klass.getCanonicalName(), this.state);
        }
        Constructor constructor = Constructors.getNoArgumentConstructor(klass);
        if (constructor != null) {
            return constructor;
        }
        throw new ConfigurationError("No valid constructors for " + klass.getCanonicalName(), this.state);
    }

    private <T extends AccessorConnectionSettings> List<Constructor<T>> getConstructors(Class<T> klass) {
        return Arrays.stream(klass.getConstructors()).map(constructor -> constructor).collect(Collectors.toList());
    }

    @Generated
    public AccessorConnectionSettings getAccessorConnectionSettings() {
        return this.accessorConnectionSettings;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public Class<? extends AccessorConnectionSettings> getConnectionClass() {
        return this.connectionClass;
    }

    @Generated
    public Constructor<? extends AccessorConnectionSettings> getConnectionConstructor() {
        return this.connectionConstructor;
    }

    @Generated
    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }

    @Generated
    public ConfigurationState getState() {
        return this.state;
    }
}

