/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration;

import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.configuration.Configuration;
import com.mx.path.core.utility.reflection.ClassHelper;
import com.mx.path.gateway.configuration.Configurable;
import com.mx.path.gateway.configuration.ConfigurationBinder;
import com.mx.path.gateway.configuration.ConfigurationError;
import com.mx.path.gateway.configuration.ConfigurationState;
import com.mx.path.gateway.configuration.annotations.ClientID;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class GatewayObjectConfigurator {
    private final ConfigurationState state;

    public GatewayObjectConfigurator(ConfigurationState state) {
        this.state = state;
    }

    public <T> T buildFromNode(ObjectMap map, String clientId, Class<T> klass) {
        ConfigurationBinder binder = new ConfigurationBinder(clientId, this.state);
        Class targetClass = new ClassHelper().getClass(map.getAsString("class"));
        ObjectMap configurations = map.getMap("configurations");
        if (!klass.isAssignableFrom(targetClass)) {
            throw new ConfigurationError(klass.getCanonicalName() + " is not assignable from " + targetClass.getCanonicalName(), this.state);
        }
        return (T)this.state.withLevel(targetClass.getSimpleName(), () -> {
            Constructor constructor = this.findBestConstructor(targetClass);
            ArrayList<Object> constructorArgs = new ArrayList<Object>();
            Arrays.stream(constructor.getParameters()).forEach(param -> {
                if (param.getType() == ObjectMap.class) {
                    constructorArgs.add(configurations);
                    return;
                }
                if (param.isAnnotationPresent(ClientID.class)) {
                    constructorArgs.add(clientId);
                    return;
                }
                Configuration configurationAnnotation = param.getAnnotation(Configuration.class);
                if (configurationAnnotation != null) {
                    this.state.withLevel(param.getType().getSimpleName(), () -> constructorArgs.add(binder.build(param.getType(), configurations)));
                }
            });
            Object result = this.build(constructor, constructorArgs);
            if (Configurable.class.isAssignableFrom(targetClass)) {
                ((Configurable)result).initialize();
                ((Configurable)result).validate(this.state);
            }
            return result;
        });
    }

    private <T> T build(Constructor<T> constructor, List<Object> args) {
        try {
            return constructor.newInstance(args.toArray());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ConfigurationError("Unable to construct object", this.state);
        }
    }

    private <T> Constructor<T> findBestConstructor(Class<T> klass) {
        List<Constructor<Object>> constructors = Arrays.asList(klass.getDeclaredConstructors());
        if ((constructors = constructors.stream().filter(constructor -> Arrays.stream(constructor.getParameters()).allMatch(param -> param.getType() == ObjectMap.class || param.isAnnotationPresent(Configuration.class) || param.isAnnotationPresent(ClientID.class))).collect(Collectors.toList())).size() > 1) {
            throw new ConfigurationError("Too many valid constructors for " + klass.getCanonicalName(), this.state);
        }
        if (constructors.isEmpty()) {
            throw new ConfigurationError("No valid constructors for " + klass.getCanonicalName(), this.state);
        }
        return constructors.get(0);
    }
}

