/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.configuration.annotations;

import java.util.Objects;

public enum AccessorScope {
    SINGLETON(3, "singleton"),
    PROTOTYPE(1, "prototype");

    private final String name;
    private final int value;

    private AccessorScope(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final int getValue() {
        return this.value;
    }

    public static AccessorScope resolve(int value) {
        for (AccessorScope a : AccessorScope.values()) {
            if (a.value != value) continue;
            return a;
        }
        return null;
    }

    public static AccessorScope resolve(String name) {
        for (AccessorScope a : AccessorScope.values()) {
            if (!Objects.equals(name, a.name)) continue;
            return a;
        }
        return null;
    }
}

