/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.connect.filter;

import com.mx.path.core.common.connect.ConnectException;
import com.mx.path.core.common.connect.Request;
import com.mx.path.core.common.connect.RequestFilterBase;
import com.mx.path.core.common.connect.Response;
import com.mx.path.core.common.http.HttpStatus;
import com.mx.path.core.common.process.FaultTolerantExecutor;
import com.mx.path.core.context.RequestContext;
import com.mx.path.core.context.facility.Facilities;
import com.mx.path.gateway.context.GatewayRequestContext;

public class FaultTolerantRequestFilter
extends RequestFilterBase {
    public final void execute(Request request, Response response) {
        FaultTolerantExecutor faultTolerantExecutor = Facilities.getFaultTolerantExecutor((String)RequestContext.current().getClientId());
        if (faultTolerantExecutor != null) {
            try {
                String scope = request.getFaultTolerantScope() != null ? request.getFaultTolerantScope() : this.buildScope();
                faultTolerantExecutor.submit(scope, scopeConfigurations -> {
                    if (request.getRequestTimeOut() == null) {
                        request.withTimeOut(scopeConfigurations.getTimeout());
                    }
                    this.next(request, response);
                    return null;
                });
            }
            catch (ConnectException e) {
                response.withBody("** MX INTERNAL FAULT TOLERANCE ERROR: " + e.getStatus().name() + " **");
                response.withStatus(e.getStatus().toHttpStatus());
                throw e;
            }
            catch (Exception e) {
                response.withBody("** MX INTERNAL FAULT TOLERANCE ERROR **");
                response.withStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                throw new ConnectException("Upstream API request failure", (Throwable)e);
            }
        } else {
            this.next(request, response);
        }
    }

    final String buildScope() {
        StringBuilder sb = new StringBuilder();
        sb.append("http");
        if (RequestContext.current().getFeature() != null) {
            sb.append(".");
            sb.append(RequestContext.current().getFeature());
        }
        if (GatewayRequestContext.current() != null && GatewayRequestContext.current().getOp() != null) {
            sb.append(".");
            sb.append(GatewayRequestContext.current().getOp());
        }
        return sb.toString();
    }
}

