/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.connect.filter;

import com.mx.path.core.common.collection.MultiValueMap;
import com.mx.path.core.common.collection.MultiValueMappable;
import com.mx.path.core.common.connect.Request;
import com.mx.path.core.common.connect.RequestFilterBase;
import com.mx.path.core.common.connect.Response;
import com.mx.path.core.context.tracing.CustomTracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.LinkedHashMap;

public class TracingFilter
extends RequestFilterBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Request request, Response response) {
        Span span = CustomTracer.startSpan((String)request.getTraceKey());
        if (span == null) {
            this.next(request, response);
            return;
        }
        try (Scope scope = CustomTracer.activateSpan((Span)span);){
            try {
                LinkedHashMap<String, String> traceHeaders = new LinkedHashMap<String, String>();
                CustomTracer.injectSpanContextIntoHeaders(traceHeaders);
                MultiValueMap requestHeaders = new MultiValueMap((MultiValueMappable)request.getHeaders());
                traceHeaders.forEach((arg_0, arg_1) -> ((MultiValueMap)requestHeaders).add(arg_0, arg_1));
                request.setTraceId(span.context().toTraceId());
                request.setTraceSpanId(span.context().toSpanId());
                this.next(request, response);
            }
            catch (Exception e) {
                span.log(e.getMessage());
                throw e;
            }
        }
        finally {
            span.finish();
        }
    }
}

