/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.context;

import com.mx.path.core.common.gateway.GatewayException;
import com.mx.path.core.common.session.ServiceScope;
import com.mx.path.core.context.ScopeKeyGenerator;
import com.mx.path.core.utility.reflection.ClassHelper;
import com.mx.path.gateway.Gateway;
import com.mx.path.gateway.accessor.Accessor;
import com.mx.path.gateway.configuration.AccessorProxy;
import com.mx.path.gateway.context.GatewayRequestContext;

public enum Scope implements ScopeKeyGenerator
{
    Session{

        public String generate() {
            return "Session";
        }
    }
    ,
    Service{

        public String generate() {
            GatewayRequestContext requestContext = GatewayRequestContext.current();
            if (requestContext == null || requestContext.getCurrentAccessor() == null && requestContext.getGateway() == null) {
                return Session.generate();
            }
            Accessor accessor = requestContext.getCurrentAccessor();
            if (accessor instanceof AccessorProxy) {
                accessor = (Accessor)new ClassHelper().invokeMethod(Accessor.class, (Object)accessor, "build", new Object[0]);
            }
            if (accessor.getClass().isAnnotationPresent(ServiceScope.class)) {
                return accessor.getClass().getAnnotation(ServiceScope.class).value();
            }
            Object baseAccessor = ((Gateway)requestContext.getGateway()).getBaseAccessor();
            if (AccessorProxy.class.isAssignableFrom(baseAccessor.getClass())) {
                baseAccessor = ((AccessorProxy)baseAccessor).build();
            }
            if (!baseAccessor.getClass().isAnnotationPresent(ServiceScope.class)) {
                throw new GatewayException("BaseAccessor: " + baseAccessor.getClass().getCanonicalName() + " is missing @ServiceScope annotation");
            }
            return baseAccessor.getClass().getAnnotation(ServiceScope.class).value();
        }
    };

}

