/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.event;

import com.google.common.eventbus.Subscribe;
import com.mx.path.core.common.collection.ObjectMap;
import com.mx.path.core.common.event.EventBus;
import com.mx.path.core.common.reflection.Annotations;
import com.mx.path.gateway.event.AccessorEvent;
import com.mx.path.gateway.event.DefaultEventHandler;
import com.mx.path.gateway.event.GatewayEvent;
import com.mx.path.gateway.event.GatewayEventBusException;
import com.mx.path.gateway.event.UpstreamRequestEvent;
import com.mx.path.gateway.util.UpstreamRequestLoggingEventListener;
import java.util.Arrays;
import java.util.List;

public class GatewayEventBus
implements EventBus {
    private final com.google.common.eventbus.EventBus eventBus = new com.google.common.eventbus.EventBus();

    public GatewayEventBus(ObjectMap configuration) {
        this.eventBus.register((Object)new DefaultEventHandler());
        this.eventBus.register((Object)new UpstreamRequestLoggingEventListener());
    }

    public void post(Object event) {
        this.eventBus.post(event);
    }

    public void register(Object subscriber) {
        this.checkSubscriber(subscriber);
        this.eventBus.register(subscriber);
    }

    private void checkSubscriber(Object subscriber) {
        List subscribeMethods = Annotations.methodsWithAnnotation(Subscribe.class, subscriber.getClass());
        if (subscribeMethods.size() == 0) {
            throw new GatewayEventBusException("Invalid event bus subscriber class - " + subscriber.getClass() + " has no methods annotated @Subscriber");
        }
        subscribeMethods.forEach(method -> {
            Class<?>[] parameters = method.getParameterTypes();
            Arrays.asList(parameters).forEach(parameterClass -> {
                if (!(GatewayEvent.class.isAssignableFrom((Class<?>)parameterClass) || AccessorEvent.class.isAssignableFrom((Class<?>)parameterClass) || UpstreamRequestEvent.class.isAssignableFrom((Class<?>)parameterClass))) {
                    throw new GatewayEventBusException("Invalid event bus subscriber - " + subscriber.getClass().getCanonicalName() + "." + method.getName() + " handles event type " + parameterClass.getCanonicalName() + " which does not implement GatewayEvent, AccessorEvent, or UpstreamRequestEvent");
                }
            });
        });
    }
}

