/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.process;

import com.mx.path.core.context.RequestContext;
import com.mx.path.core.context.Session;
import com.mx.path.core.context.tracing.CustomTracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.concurrent.Callable;
import lombok.Generated;

public abstract class CallableWithGatewayContext<T>
implements Callable<T> {
    private final RequestContext requestContext;
    private final Session session = Session.current();
    private final Span span;

    public CallableWithGatewayContext() {
        this.requestContext = RequestContext.current();
        this.span = CustomTracer.getTracer().activeSpan();
    }

    @Override
    public final T call() throws Exception {
        T result;
        try (Scope scope = CustomTracer.getTracer().activateSpan(this.span);){
            Session.setCurrent((Session)this.session);
            this.requestContext.register();
            try {
                result = this.execute();
            }
            finally {
                Session.clearSession();
                RequestContext.clear();
            }
        }
        return result;
    }

    protected abstract T execute() throws Exception;

    @Generated
    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    @Generated
    public Session getSession() {
        return this.session;
    }

    @Generated
    public Span getSpan() {
        return this.span;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallableWithGatewayContext)) {
            return false;
        }
        CallableWithGatewayContext other = (CallableWithGatewayContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestContext this$requestContext = this.getRequestContext();
        RequestContext other$requestContext = other.getRequestContext();
        if (this$requestContext == null ? other$requestContext != null : !this$requestContext.equals(other$requestContext)) {
            return false;
        }
        Session this$session = this.getSession();
        Session other$session = other.getSession();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        Span this$span = this.getSpan();
        Span other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !this$span.equals(other$span));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CallableWithGatewayContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestContext $requestContext = this.getRequestContext();
        result = result * 59 + ($requestContext == null ? 43 : $requestContext.hashCode());
        Session $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        Span $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CallableWithGatewayContext(requestContext=" + this.getRequestContext() + ", session=" + this.getSession() + ", span=" + this.getSpan() + ")";
    }
}

