/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.process;

import com.mx.path.core.common.gateway.GatewayException;
import com.mx.path.gateway.process.AsyncWithGatewayContext;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public final class FutureWithGatewayContext<T> {
    private static final long DEFAULT_RETRIEVAL_TIMEOUT_MILLIS = 10000L;
    private static final int DEFAULT_THREAD_POOL_SIZE = 20;
    private static final ExecutorService DEFAULT_EXECUTOR = Executors.newFixedThreadPool(20);
    private long timeoutMillis = 10000L;
    private final Future<T> future;

    public FutureWithGatewayContext(Supplier<T> lambda) {
        this.future = DEFAULT_EXECUTOR.submit(new AsyncWithGatewayContext<T>(lambda));
    }

    public FutureWithGatewayContext(Supplier<T> lambda, long timeoutMillis) {
        this.future = DEFAULT_EXECUTOR.submit(new AsyncWithGatewayContext<T>(lambda));
        this.timeoutMillis = timeoutMillis;
    }

    public FutureWithGatewayContext(Supplier<T> lambda, ExecutorService executorService) {
        this.future = executorService.submit(new AsyncWithGatewayContext<T>(lambda));
    }

    public FutureWithGatewayContext(Supplier<T> lambda, ExecutorService executorService, long timeoutMillis) {
        this.future = executorService.submit(new AsyncWithGatewayContext<T>(lambda));
        this.timeoutMillis = timeoutMillis;
    }

    public T get() {
        try {
            return this.future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new GatewayException("FutureWithGatewayContext timeout out", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new GatewayException("FutureWithGatewayContext was interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new GatewayException("FutureWithGatewayContext execution failed", (Throwable)e);
        }
    }
}

