/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.util;

import com.mx.path.core.common.accessor.RequestPayloadException;
import com.mx.path.core.common.accessor.ResponsePayloadException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;

public class SoapMarshaller {
    private static Map<Class, JAXBContext> jaxbContextMap = new HashMap<Class, JAXBContext>();

    public static String toEnvelope(Object requestObj) {
        if (requestObj instanceof JAXBElement) {
            throw new RequestPayloadException("Trying to marshall JAXBElement without specifying class. Use toEnvelope(Object requestObj, Class<?> klass) instead.", null);
        }
        return SoapMarshaller.toEnvelope(requestObj, requestObj.getClass());
    }

    public static String toEnvelope(Object requestObj, Class<?> klass) {
        return SoapMarshaller.toEnvelope(null, null, requestObj, klass);
    }

    public static String toEnvelope(Object requestHeaderObj, Class headerKlass, Object requestBodyObj, Class bodyKlass) {
        try {
            SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
            if (requestHeaderObj != null) {
                JAXBContext headerContext = jaxbContextMap.get(headerKlass);
                if (headerContext == null) {
                    headerContext = JAXBContext.newInstance((Class[])new Class[]{headerKlass});
                    jaxbContextMap.put(headerKlass, headerContext);
                }
                Marshaller headerMarshaller = headerContext.createMarshaller();
                headerMarshaller.marshal(requestHeaderObj, (Node)soapMessage.getSOAPHeader());
            }
            if (requestBodyObj != null) {
                JAXBContext bodyContext = jaxbContextMap.get(bodyKlass);
                if (bodyContext == null) {
                    bodyContext = JAXBContext.newInstance((Class[])new Class[]{bodyKlass});
                    jaxbContextMap.put(bodyKlass, bodyContext);
                }
                Marshaller bodyMarshaller = bodyContext.createMarshaller();
                bodyMarshaller.marshal(requestBodyObj, (Node)soapMessage.getSOAPBody());
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)outputStream);
            return new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException | JAXBException | SOAPException ex) {
            throw new RequestPayloadException(ex.getMessage(), ex);
        }
    }

    public static <T> T toResponse(String envelopeXml, Class<T> klass) {
        try {
            SOAPMessage message = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream(envelopeXml.getBytes(StandardCharsets.UTF_8)));
            JAXBContext responseContext = jaxbContextMap.get(klass);
            if (responseContext == null) {
                responseContext = JAXBContext.newInstance((Class[])new Class[]{klass});
                jaxbContextMap.put(klass, responseContext);
            }
            Unmarshaller unmarshaller = responseContext.createUnmarshaller();
            JAXBElement response = unmarshaller.unmarshal((Node)message.getSOAPBody().extractContentAsDocument(), klass);
            return (T)response.getValue();
        }
        catch (IOException | JAXBException | SOAPException ex) {
            throw new ResponsePayloadException(ex.getMessage(), ex);
        }
    }
}

