/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mx.path.core.common.collection.MultiValueMap;
import com.mx.path.core.common.collection.SingleValueMap;
import com.mx.path.core.common.connect.Request;
import com.mx.path.core.common.connect.Response;
import com.mx.path.core.common.security.LogValueMasker;
import com.mx.path.core.context.RequestContext;
import com.mx.path.core.context.Session;
import com.mx.path.gateway.util.LoggingExceptionFormatter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class UpstreamLogger {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
    private static final LogValueMasker LOGMASKER = new LogValueMasker();
    private static Logger logger = LoggerFactory.getLogger(UpstreamLogger.class);

    public static void setLogger(Logger logger) {
        UpstreamLogger.logger = logger;
    }

    public static void resetLogger() {
        logger = LoggerFactory.getLogger(UpstreamLogger.class);
    }

    public final void logRequest(Response response) {
        RequestContext requestContext = RequestContext.current();
        MDC.put((String)"client_guid", (String)requestContext.getClientGuid());
        MDC.put((String)"client_id", (String)requestContext.getClientId());
        MDC.put((String)"path", (String)requestContext.getPath());
        if (requestContext.getUserGuid() != null) {
            MDC.put((String)"user_guid", (String)requestContext.getUserGuid());
        } else {
            MDC.remove((String)"user_guid");
        }
        if (Session.current() != null && Session.current().getUserId() != null) {
            MDC.put((String)"user_id", (String)Session.current().getUserId());
        } else if (requestContext.getUserId() != null) {
            MDC.put((String)"user_id", (String)requestContext.getUserId());
        } else {
            MDC.remove((String)"user_id");
        }
        if (requestContext.getFeature() != null) {
            MDC.put((String)"feature", (String)requestContext.getFeature());
        } else {
            MDC.remove((String)"feature");
        }
        if (requestContext.getOriginatingIP() != null) {
            MDC.put((String)"ip_address", (String)requestContext.getOriginatingIP());
        } else {
            MDC.remove((String)"ip_address");
        }
        if (requestContext.getSessionTraceId() != null) {
            MDC.put((String)"session_trace_id", (String)requestContext.getSessionTraceId());
        } else {
            MDC.remove((String)"session_trace_id");
        }
        if (requestContext.getDeviceTraceId() != null) {
            MDC.put((String)"device_trace_id", (String)requestContext.getDeviceTraceId());
        } else {
            MDC.remove((String)"device_trace_id");
        }
        Request request = response.getRequest();
        MDC.put((String)"request_method", (String)request.getMethod());
        MDC.put((String)"request_uri", (String)request.getUri());
        MDC.put((String)"span_id", (String)request.getTraceSpanId());
        MDC.put((String)"trace_id", (String)request.getTraceId());
        if (request.getHeaders() != null) {
            Map<String, String> maskedRequestHeaders = this.maskHeaders((Map<String, String>)request.getHeaders());
            MDC.put((String)"request_headers_json", (String)GSON.toJson(maskedRequestHeaders));
            MDC.put((String)"request_headers", (String)this.buildHeaderString(maskedRequestHeaders));
        } else {
            MDC.remove((String)"request_headers_json");
            MDC.remove((String)"request_headers");
        }
        if (request.getQueryStringParams() != null) {
            SingleValueMap queryParams = request.getQueryStringParams();
            MDC.put((String)"query_params", (String)this.buildHeaderString(this.maskHeaders((Map<String, String>)queryParams)));
        } else {
            MDC.remove((String)"query_params");
        }
        if (request.getBodyJson() != null) {
            MDC.put((String)"request_body", (String)LOGMASKER.maskPayload(request.getBodyJson()));
        } else if (request.getFormBody() != null) {
            MDC.put((String)"request_body", (String)LOGMASKER.maskPayload(this.encodeFormData((MultiValueMap<String, String>)request.getFormBody().toForm())));
        } else if (request.getBody() != null) {
            MDC.put((String)"request_body", (String)LOGMASKER.maskPayload(request.getBody().toString()));
        } else {
            MDC.remove((String)"request_body");
        }
        MDC.put((String)"api_call_payload", (String)this.buildApiPayload(response, request));
        if (response.getDuration() != null) {
            MDC.put((String)"request_duration", (String)String.valueOf(response.getDuration().toMillis()));
        } else {
            MDC.remove((String)"request_duration");
        }
        if (response.getStatus() != null) {
            MDC.put((String)"status", (String)String.valueOf(response.getStatus().value()));
        } else {
            MDC.remove((String)"status");
        }
        if (response.hasBody()) {
            MDC.put((String)"response_body", (String)LOGMASKER.maskPayload(response.getBody()));
        } else {
            MDC.remove((String)"response_body");
        }
        if (response.getHeaders() != null) {
            Map<String, String> maskedResponseHeaders = this.maskHeaders((Map<String, String>)response.getHeaders());
            MDC.put((String)"response_headers_json", (String)GSON.toJson(maskedResponseHeaders));
            MDC.put((String)"response_headers", (String)this.buildHeaderString(maskedResponseHeaders));
        } else {
            MDC.remove((String)"response_headers_json");
            MDC.remove((String)"response_headers");
        }
        MDC.put((String)"log_guid", (String)UUID.randomUUID().toString());
        if (response.getException() != null) {
            Exception exception = response.getException();
            MDC.put((String)"exception", (String)LoggingExceptionFormatter.formatLoggingExceptionWithStacktrace(exception));
            logger.error("Upstream request failed", (Throwable)exception);
        } else {
            MDC.remove((String)"exception");
            logger.info("Upstream Request");
        }
        MDC.remove((String)"api_call_payload");
        MDC.remove((String)"client_guid");
        MDC.remove((String)"client_id");
        MDC.remove((String)"device_trace_id");
        MDC.remove((String)"exception");
        MDC.remove((String)"parent_id");
        MDC.remove((String)"path");
        MDC.remove((String)"request_body");
        MDC.remove((String)"request_duration");
        MDC.remove((String)"request_headers");
        MDC.remove((String)"request_headers_json");
        MDC.remove((String)"request_method");
        MDC.remove((String)"request_uri");
        MDC.remove((String)"response_body");
        MDC.remove((String)"response_headers");
        MDC.remove((String)"response_headers_json");
        MDC.remove((String)"session_trace_id");
        MDC.remove((String)"status");
        MDC.remove((String)"span_id");
        MDC.remove((String)"trace_id");
        MDC.remove((String)"log_guid");
    }

    private String buildHeaderString(Map<String, String> headers) {
        StringBuilder headerStr = new StringBuilder();
        headers.forEach((name, value) -> {
            headerStr.append((String)name);
            headerStr.append(": ");
            headerStr.append((String)value);
            headerStr.append("\n");
        });
        return headerStr.toString();
    }

    private Map<String, String> maskHeaders(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, String> maskedHeaders = new HashMap<String, String>();
        headers.forEach((name, value) -> maskedHeaders.put((String)name, LOGMASKER.maskHeaderValue(name, value)));
        return maskedHeaders;
    }

    private String buildApiPayload(Response response, Request request) {
        SingleValueMap requestQueries;
        StringBuilder b = new StringBuilder();
        b.append("= Request\n\n");
        b.append(request.getMethod());
        b.append(" ");
        b.append(request.getUri());
        b.append("\n\n");
        Map<String, String> requestHeaders = this.maskHeaders((Map<String, String>)request.getHeaders());
        if (requestHeaders != null) {
            b.append(this.buildHeaderString(requestHeaders));
        }
        if ((requestQueries = request.getQueryStringParams()) != null) {
            b.append(this.buildHeaderString(this.maskHeaders((Map<String, String>)requestQueries)));
        }
        if (request.getBodyJson() != null) {
            b.append("\n");
            b.append(LOGMASKER.maskPayload(request.getBodyJson()));
            b.append("\n");
        } else if (request.getFormBody() != null) {
            b.append("\n");
            b.append(LOGMASKER.maskPayload(this.encodeFormData((MultiValueMap<String, String>)request.getFormBody().toForm())));
            b.append("\n");
        } else if (request.getBody() != null) {
            b.append("\n");
            b.append(LOGMASKER.maskPayload(request.getBody().toString()));
            b.append("\n");
        }
        b.append("\n= Response\n\n");
        b.append(response.getStatus());
        b.append("\n");
        Map<String, String> responseHeaders = this.maskHeaders((Map<String, String>)response.getHeaders());
        if (responseHeaders != null) {
            b.append(this.buildHeaderString(responseHeaders));
        }
        if (response.hasBody()) {
            b.append(LOGMASKER.maskPayload(response.getBody()));
        }
        return b.toString();
    }

    private String encodeFormData(MultiValueMap<String, String> data) {
        return data.toSingleValueMap().entrySet().stream().map(e -> {
            try {
                return (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.toString());
            }
            catch (Exception ex) {
                logger.error("Unable to encode form data for logging", (Throwable)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.joining("&"));
    }
}

