/*
 * Decompiled with CFR 0.152.
 */
package com.mx.path.gateway.util;

import com.google.common.eventbus.Subscribe;
import com.mx.path.core.context.RequestContext;
import com.mx.path.core.context.Session;
import com.mx.path.gateway.event.AfterUpstreamRequestEvent;
import com.mx.path.gateway.util.UpstreamLogger;
import java.util.function.BiConsumer;
import lombok.Generated;

public class UpstreamRequestLoggingEventListener {
    private static UpstreamLogger upstreamLogger = new UpstreamLogger();

    @Subscribe
    public final void onAfterUpstreamRequestEvent(AfterUpstreamRequestEvent afterUpstreamRequestEvent) {
        this.withContext(afterUpstreamRequestEvent.getSession(), afterUpstreamRequestEvent.getRequestContext(), (req, sess) -> {
            if (afterUpstreamRequestEvent.getResponse() != null) {
                upstreamLogger.logRequest(afterUpstreamRequestEvent.getResponse());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withContext(Session session, RequestContext requestContext, BiConsumer<Session, RequestContext> block) {
        Session currentSession = Session.current();
        if (session != null) {
            Session.setCurrent((Session)session);
        }
        RequestContext currentRequestContext = RequestContext.current();
        if (requestContext != null) {
            requestContext.register();
        }
        try {
            block.accept(session, requestContext);
        }
        finally {
            if (currentRequestContext != null) {
                currentRequestContext.register();
            } else {
                RequestContext.clear();
            }
            if (currentSession != null) {
                Session.setCurrent((Session)currentSession);
            } else {
                Session.clearSession();
            }
        }
    }

    @Generated
    public static void setUpstreamLogger(UpstreamLogger upstreamLogger) {
        UpstreamRequestLoggingEventListener.upstreamLogger = upstreamLogger;
    }
}

