/**
 * Copyright (C) 2013 Mycila (mathieu@mycila.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.iron.ironmq;

import java.io.IOException;

/**
 * The EmptyQueueException class represents a response from IronMQ indicating
 * the queue is empty.
 */
public class EmptyQueueException extends IOException {
    /**
    * Creates a new EmptyQueueException.
    */
    public EmptyQueueException() {
        super("Queue is empty");
    }
}
