/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicStopwatch;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.StatsMonitor;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.stats.StatsConfig;
import com.netflix.servo.tag.Tag;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class QueueMonitor {
    BasicTimer peek;
    BasicTimer ack;
    BasicTimer size;
    BasicTimer processUnack;
    BasicTimer remove;
    BasicTimer get;
    StatsMonitor queueDepth;
    StatsMonitor batchSize;
    StatsMonitor pop;
    StatsMonitor push;
    BasicCounter misses;
    StatsMonitor prefetch;
    private String queueName;
    private String shardName;
    private static final String className = QueueMonitor.class.getSimpleName();

    QueueMonitor(String queueName, String shardName) {
        String totalTagName = "total";
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        this.queueName = queueName;
        this.shardName = shardName;
        this.peek = new BasicTimer(this.create("peek"), TimeUnit.MILLISECONDS);
        this.ack = new BasicTimer(this.create("ack"), TimeUnit.MILLISECONDS);
        this.size = new BasicTimer(this.create("size"), TimeUnit.MILLISECONDS);
        this.processUnack = new BasicTimer(this.create("processUnack"), TimeUnit.MILLISECONDS);
        this.remove = new BasicTimer(this.create("remove"), TimeUnit.MILLISECONDS);
        this.get = new BasicTimer(this.create("get"), TimeUnit.MILLISECONDS);
        this.misses = new BasicCounter(this.create("queue_miss"));
        StatsConfig statsConfig = new StatsConfig.Builder().withPublishCount(true).withPublishMax(true).withPublishMean(true).withPublishMin(true).withPublishTotal(true).build();
        this.queueDepth = new StatsMonitor(this.create("queueDepth"), statsConfig, executor, totalTagName, true, new Tag[0]);
        this.batchSize = new StatsMonitor(this.create("batchSize"), statsConfig, executor, totalTagName, true, new Tag[0]);
        this.pop = new StatsMonitor(this.create("pop"), statsConfig, executor, totalTagName, true, new Tag[0]);
        this.push = new StatsMonitor(this.create("push"), statsConfig, executor, totalTagName, true, new Tag[0]);
        this.prefetch = new StatsMonitor(this.create("prefetch"), statsConfig, executor, totalTagName, true, new Tag[0]);
        MonitorRegistry registry = DefaultMonitorRegistry.getInstance();
        registry.register((Monitor)this.pop);
        registry.register((Monitor)this.push);
        registry.register((Monitor)this.peek);
        registry.register((Monitor)this.ack);
        registry.register((Monitor)this.size);
        registry.register((Monitor)this.processUnack);
        registry.register((Monitor)this.remove);
        registry.register((Monitor)this.get);
        registry.register((Monitor)this.queueDepth);
        registry.register((Monitor)this.misses);
        registry.register((Monitor)this.batchSize);
        registry.register((Monitor)this.prefetch);
    }

    private MonitorConfig create(String name) {
        return MonitorConfig.builder((String)name).withTag("class", className).withTag("shard", this.shardName).withTag("queueName", this.queueName).build();
    }

    Stopwatch start(final StatsMonitor sm, int batchCount) {
        final int count = batchCount == 0 ? 1 : batchCount;
        BasicStopwatch sw = new BasicStopwatch(){

            public void stop() {
                super.stop();
                long duration = this.getDuration(TimeUnit.MILLISECONDS) / (long)count;
                sm.record(duration);
                QueueMonitor.this.batchSize.record((long)count);
            }
        };
        sw.start();
        return sw;
    }
}

