/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues.redis;

import com.netflix.dyno.queues.DynoQueue;
import com.netflix.dyno.queues.ShardSupplier;
import com.netflix.dyno.queues.redis.RedisDynoQueue;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import redis.clients.jedis.JedisCommands;

public class RedisQueues {
    private JedisCommands quorumConn;
    private JedisCommands nonQuorumConn;
    private Set<String> allShards;
    private String shardName;
    private String redisKeyPrefix;
    private int unackTime;
    private int unackHandlerIntervalInMS;
    private ConcurrentHashMap<String, DynoQueue> queues;
    private ExecutorService dynoCallExecutor;

    public RedisQueues(JedisCommands quorumConn, JedisCommands nonQuorumConn, String redisKeyPrefix, ShardSupplier shardSupplier, int unackTime, int unackHandlerIntervalInMS, int dynoOpThreadCount) {
        this.quorumConn = quorumConn;
        this.nonQuorumConn = nonQuorumConn;
        this.redisKeyPrefix = redisKeyPrefix;
        this.allShards = shardSupplier.getQueueShards();
        this.shardName = shardSupplier.getCurrentShard();
        this.unackTime = unackTime;
        this.unackHandlerIntervalInMS = unackHandlerIntervalInMS;
        this.queues = new ConcurrentHashMap();
        this.dynoCallExecutor = Executors.newFixedThreadPool(dynoOpThreadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynoQueue get(String queueName) {
        String key = queueName.intern();
        DynoQueue queue = this.queues.get(key);
        if (queue != null) {
            return queue;
        }
        RedisQueues redisQueues = this;
        synchronized (redisQueues) {
            queue = new RedisDynoQueue(this.redisKeyPrefix, queueName, this.allShards, this.shardName, this.dynoCallExecutor).withUnackTime(this.unackTime).withUnackSchedulerTime(this.unackHandlerIntervalInMS).withNonQuorumConn(this.nonQuorumConn).withQuorumConn(this.quorumConn);
            this.queues.put(key, queue);
        }
        return queue;
    }

    public Collection<DynoQueue> queues() {
        return this.queues.values();
    }
}

